/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.internal;

import de.skuzzle.tinyplugz.DeployListener;
import de.skuzzle.tinyplugz.PluginInformation;
import de.skuzzle.tinyplugz.PluginSource;
import de.skuzzle.tinyplugz.TinyPlugz;
import de.skuzzle.tinyplugz.internal.DelegateClassLoader;
import de.skuzzle.tinyplugz.internal.ServiceLoaderWrapper;
import de.skuzzle.tinyplugz.util.ElementIterator;
import de.skuzzle.tinyplugz.util.ReflectionUtil;
import de.skuzzle.tinyplugz.util.Require;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

final class DefaultTinyPlugz
extends TinyPlugz {
    private ServiceLoaderWrapper serviceLoader;
    private DelegateClassLoader pluginClassLoader;

    DefaultTinyPlugz() {
    }

    @Override
    protected final void initialize(PluginSource source, ClassLoader parentClassLoader, Map<Object, Object> properties) {
        this.pluginClassLoader = this.createClassLoader(source, parentClassLoader);
        this.serviceLoader = properties.containsKey("tinyplugz.serviceLoaderWrapper") ? ReflectionUtil.createInstance(properties.get("tinyplugz.serviceLoaderWrapper"), ServiceLoaderWrapper.class, parentClassLoader) : ServiceLoaderWrapper.getDefault();
    }

    @Override
    public final Collection<PluginInformation> getPluginInformation() {
        return this.pluginClassLoader.getInformation();
    }

    @Override
    protected final Iterator<DeployListener> findDeployListeners(ClassLoader pluginClassLoader) {
        return this.serviceLoader.loadService(DeployListener.class, pluginClassLoader);
    }

    @Override
    protected final void dispose() {
        this.defaultDispose();
    }

    @Override
    public final ClassLoader getClassLoader() {
        return this.pluginClassLoader;
    }

    @Override
    public final void runMain(String className, String[] args) {
        Require.nonNull(className, "className");
        Require.nonNull(args, "args");
        this.defaultRunMain(className, args);
    }

    @Override
    public final Optional<URL> getResource(String name) {
        Require.nonNull(name, "name");
        return this.defaultGetResource(name);
    }

    @Override
    public final ElementIterator<URL> getResources(String name) throws IOException {
        Require.nonNull(name, "name");
        return this.defaultGetResources(name);
    }

    @Override
    public final <T> ElementIterator<T> getServices(Class<T> type) {
        Require.nonNull(type, "type");
        Require.state(this.serviceLoader != null, "not initialized", new Object[0]);
        return this.serviceLoader.loadService(type, this.pluginClassLoader);
    }

    @Override
    public final <T> Optional<T> getFirstService(Class<T> type) {
        Require.nonNull(type, "type");
        return this.defaultGetFirstService(type);
    }

    @Override
    public final <T> T getService(Class<T> type) {
        Require.nonNull(type, "type");
        return this.defaultGetService(type);
    }
}

