/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.internal;

import de.skuzzle.tinyplugz.PluginInformation;
import de.skuzzle.tinyplugz.internal.DelegateDependencyResolver;
import de.skuzzle.tinyplugz.internal.DependencyResolver;
import de.skuzzle.tinyplugz.internal.PluginClassLoader;
import de.skuzzle.tinyplugz.util.ElementIterator;
import de.skuzzle.tinyplugz.util.Require;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DelegateClassLoader
extends ClassLoader
implements Closeable {
    private static final Logger LOG;
    private final DependencyResolver delegator;
    private final Collection<PluginInformation> information;

    DelegateClassLoader(ClassLoader parent, DependencyResolver delegator, Collection<PluginInformation> information) {
        super(parent);
        this.delegator = delegator;
        this.information = Collections.unmodifiableCollection(information);
    }

    public static DelegateClassLoader forPlugins(Stream<URL> urls, final ClassLoader appClassLoader) {
        Require.nonNull(urls, "urls");
        Require.nonNull(appClassLoader, "parent");
        ArrayList<DependencyResolver> plugins = new ArrayList<DependencyResolver>();
        final ArrayList<PluginInformation> information = new ArrayList<PluginInformation>();
        final DelegateDependencyResolver delegator = new DelegateDependencyResolver(plugins);
        Iterator it = urls.iterator();
        while (it.hasNext()) {
            URL pluginURL = (URL)it.next();
            PluginClassLoader pluginCl = PluginClassLoader.create(pluginURL, appClassLoader, delegator);
            plugins.add(pluginCl);
            information.add(pluginCl.getPluginInformation());
        }
        return AccessController.doPrivileged(new PrivilegedAction<DelegateClassLoader>(){

            @Override
            public DelegateClassLoader run() {
                return new DelegateClassLoader(appClassLoader, delegator, information);
            }
        });
    }

    public final Collection<PluginInformation> getInformation() {
        return this.information;
    }

    @Override
    protected final Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> cls = this.delegator.findClass(null, name);
        if (cls == null) {
            throw new ClassNotFoundException(name);
        }
        return cls;
    }

    @Override
    protected final URL findResource(String name) {
        LOG.trace("delegate.findResource('{}')", (Object)name);
        return this.delegator.findResource(null, name);
    }

    @Override
    protected final Enumeration<URL> findResources(String name) throws IOException {
        LOG.trace("delegate.findResources('{}')", (Object)name);
        ArrayList<URL> urls = new ArrayList<URL>();
        this.delegator.findResources(null, name, urls);
        return ElementIterator.wrap(urls.iterator());
    }

    @Override
    public final void close() throws IOException {
        this.delegator.close();
    }

    public final String toString() {
        return "TinyPlugz DelegateClassLoader";
    }

    static {
        DelegateClassLoader.registerAsParallelCapable();
        LOG = LoggerFactory.getLogger(DelegateClassLoader.class);
    }
}

