/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.internal;

import de.skuzzle.tinyplugz.internal.DependencyResolver;
import de.skuzzle.tinyplugz.util.Closeables;
import de.skuzzle.tinyplugz.util.Require;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DelegateDependencyResolver
implements DependencyResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DelegateDependencyResolver.class);
    private final Collection<DependencyResolver> children;
    private final Map<String, DependencyResolver> packageIndex;

    DelegateDependencyResolver(Collection<DependencyResolver> children) {
        this.children = Require.nonNull(children, "children");
        this.packageIndex = new HashMap<String, DependencyResolver>();
    }

    private String getPackageName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return name.substring(0, lastDot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Class<?> findClass(@Nullable DependencyResolver requestor, String name) {
        Class<?> indexCls;
        DependencyResolver indexResolver;
        Require.nonNull(name, "name");
        String packageName = this.getPackageName(name);
        Map<String, DependencyResolver> map = this.packageIndex;
        synchronized (map) {
            indexResolver = this.packageIndex.get(packageName);
        }
        if (indexResolver != null && !indexResolver.equals(requestor) && (indexCls = indexResolver.findClass(requestor, name)) != null) {
            return indexCls;
        }
        for (DependencyResolver pluginCl : this.children) {
            Class<?> cls;
            if (pluginCl.equals(requestor) || pluginCl.equals(indexResolver) || (cls = pluginCl.findClass(requestor, name)) == null) continue;
            Map<String, DependencyResolver> map2 = this.packageIndex;
            synchronized (map2) {
                LOG.trace("Update package index mapping: {} -> {}", (Object)packageName, (Object)pluginCl);
                this.packageIndex.put(packageName, pluginCl);
            }
            return cls;
        }
        return null;
    }

    @Override
    public final URL findResource(DependencyResolver requestor, String name) {
        Require.nonNull(name, "name");
        for (DependencyResolver pluginCl : this.children) {
            URL url;
            if (pluginCl.equals(requestor) || (url = pluginCl.findResource(requestor, name)) == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public final void findResources(DependencyResolver requestor, String name, Collection<URL> target) throws IOException {
        Require.nonNull(name, "name");
        for (DependencyResolver pluginCl : this.children) {
            if (pluginCl.equals(requestor)) continue;
            pluginCl.findResources(requestor, name, target);
        }
    }

    @Override
    public final void close() throws IOException {
        Closeables.close(this.children);
    }

    @Override
    public final String getSimpleName() {
        return "Delegator";
    }
}

