/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.internal;

import de.skuzzle.tinyplugz.PluginInformation;
import de.skuzzle.tinyplugz.internal.DependencyResolver;
import de.skuzzle.tinyplugz.util.Closeables;
import de.skuzzle.tinyplugz.util.ElementIterator;
import de.skuzzle.tinyplugz.util.Require;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PluginClassLoader
extends URLClassLoader
implements DependencyResolver {
    private static final Logger LOG = LoggerFactory.getLogger(PluginClassLoader.class);
    private static final Map<String, Object> STATIC_LOCK_MAP = new HashMap<String, Object>();
    private static final String[] MANIFEST_NAMES = new String[]{"MANIFEST.MF", "MANIFEST.mf", "manifest.mf", "manifest.MF"};
    private static final Pattern WHITESPACES = Pattern.compile("\\s+");
    private final URL self;
    private final String basePath;
    private final String simpleName;
    private final URLClassLoader dependencyClassLoader;
    private final DependencyResolver dependencyResolver;
    private final Manifest manifest;
    private final PluginInformation information;
    private final ThreadLocal<Integer> foreignEnterCount = ThreadLocal.withInitial(() -> 0);
    private final ThreadLocal<Integer> localEnterCount = ThreadLocal.withInitial(() -> 0);

    private PluginClassLoader(URL pluginUrl, ClassLoader appClassLoader, DependencyResolver dependencyResolver) {
        super(new URL[]{pluginUrl}, appClassLoader);
        this.dependencyResolver = dependencyResolver;
        this.self = pluginUrl;
        this.basePath = this.getBasePathOf(pluginUrl);
        this.manifest = this.readManifest();
        this.simpleName = this.getName(this.manifest, pluginUrl);
        this.dependencyClassLoader = this.createDependencyClassLoader(this.manifest);
        this.information = new PluginInformationImpl();
    }

    static PluginClassLoader create(final URL plugin, final ClassLoader appClassLoader, final DependencyResolver dependencyResolver) {
        Require.nonNull(plugin, "plugin");
        Require.nonNull(appClassLoader, "appClassLoader");
        Require.nonNull(dependencyResolver, "dependencyResolver");
        return AccessController.doPrivileged(new PrivilegedAction<PluginClassLoader>(){

            @Override
            public PluginClassLoader run() {
                LOG.debug("Loading plugin from {}", (Object)plugin);
                return new PluginClassLoader(plugin, appClassLoader, dependencyResolver);
            }
        });
    }

    public final PluginInformation getPluginInformation() {
        return this.information;
    }

    public final String getBasePath() {
        return this.basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Object getClassLoadingLock(String className) {
        Map<String, Object> map = STATIC_LOCK_MAP;
        synchronized (map) {
            Object lock = STATIC_LOCK_MAP.get(className);
            if (lock == null) {
                lock = new Object();
                STATIC_LOCK_MAP.put(className, lock);
            }
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        LOG.trace("{}.loadClass('{}')", (Object)this.getSimpleName(), (Object)name);
        int localCount = this.localEnterCount.get();
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            try {
                this.localEnterCount.set(localCount + 1);
                if (c == null) {
                    try {
                        c = this.getParent().loadClass(name);
                    }
                    catch (ClassNotFoundException ignore) {
                        LOG.trace("Class '{}' not found using parent '{}' of '{}'", new Object[]{name, this.getParent(), this.getSimpleName(), ignore});
                    }
                }
                if (c == null) {
                    c = this.foreignEnterCount.get().equals(this.localEnterCount.get()) ? super.findClass(name) : this.findClass(name);
                }
            }
            finally {
                this.localEnterCount.set(localCount);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            ClassLoader winner = c.getClassLoader() == null ? this : c.getClassLoader();
            LOG.trace("'{}' loaded by <{}>", (Object)name, (Object)winner);
            return c;
        }
    }

    private String getBasePathOf(URL url) {
        String path = url.getPath();
        if (!path.endsWith("/")) {
            int i = path.lastIndexOf(47);
            path = path.substring(0, i + 1);
        }
        return path;
    }

    private String getName(Manifest mf, URL url) {
        String mfName = mf.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        if (mfName != null) {
            return mfName;
        }
        String path = url.getPath();
        int j = -1;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        } else {
            j = path.lastIndexOf(46);
        }
        j = j == -1 ? path.length() : j;
        int i = path.lastIndexOf(47);
        path = path.substring(i + 1, j);
        return path;
    }

    private Manifest readManifest() {
        URL mfURL = this.findManifestUrl();
        Manifest result = new Manifest();
        if (mfURL != null) {
            try (InputStream in = mfURL.openStream();){
                result = new Manifest(in);
            }
            catch (IOException e) {
                LOG.error("Error reading manifest file for {}", (Object)this.self, (Object)e);
            }
        } else {
            LOG.debug("Plugin '{}' has no manifest", (Object)this.getSimpleName());
        }
        return result;
    }

    private DependencyClassLoader createDependencyClassLoader(Manifest mf) {
        DependencyClassLoader result;
        String cp = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (cp == null) {
            LOG.debug("Plugin '{}' has no Class-Path attribute", (Object)this.getSimpleName());
            result = null;
        } else {
            String[] entries = WHITESPACES.split(cp);
            result = this.fromClassPath(entries);
        }
        return result;
    }

    private DependencyClassLoader fromClassPath(String[] entries) {
        final URL[] urls = (URL[])Arrays.stream(entries).map(this::resolveRelative).filter(url -> url != null).peek(url -> LOG.debug("Add dependency of <{}>: '{}'", (Object)this.getSimpleName(), url)).toArray(URL[]::new);
        if (urls.length > 0) {
            return AccessController.doPrivileged(new PrivilegedAction<DependencyClassLoader>(){

                @Override
                public DependencyClassLoader run() {
                    return new DependencyClassLoader(urls, PluginClassLoader.this.getParent());
                }
            });
        }
        return null;
    }

    private URL resolveRelative(String name) {
        try {
            return new URL(this.self.getProtocol(), this.self.getHost(), this.self.getPort(), this.basePath + name.trim());
        }
        catch (MalformedURLException e) {
            LOG.error("Error constructing relative url with base path '{}' and name '{}'", new Object[]{this.basePath, name, e});
            return null;
        }
    }

    private URL findManifestUrl() {
        URL url = null;
        int i = 0;
        while ((url = super.findResource("META-INF/" + MANIFEST_NAMES[i])) == null && ++i < MANIFEST_NAMES.length) {
        }
        return url;
    }

    @Override
    public final String getSimpleName() {
        return this.simpleName;
    }

    @Override
    protected final Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> cls = this.findClass(this, name);
        if (cls == null) {
            throw new ClassNotFoundException(name);
        }
        return cls;
    }

    @Override
    public final URL findResource(String name) {
        return this.findResource(this, name);
    }

    @Override
    public final Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        this.findResources(this, name, urls);
        return ElementIterator.wrap(urls.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClassForForeignPlugin(String name) throws ClassNotFoundException {
        int count = this.foreignEnterCount.get();
        try {
            this.foreignEnterCount.set(count + 1);
            Class<?> clazz = this.loadClass(name);
            return clazz;
        }
        finally {
            this.foreignEnterCount.set(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Class<?> findClass(@Nullable DependencyResolver requestor, String name) {
        Class<?> result;
        block14: {
            Require.nonNull(name, "name");
            LOG.debug("{}.findClassFor(<{}>, '{}')", new Object[]{this.getSimpleName(), this.nameOf(requestor), name});
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                result = this.findLoadedClass(name);
            }
            if (result == null) {
                try {
                    if (this.equals(requestor)) {
                        result = super.findClass(name);
                        break block14;
                    }
                    result = this.loadClassForForeignPlugin(name);
                }
                catch (ClassNotFoundException ignore) {
                    LOG.trace("Class '{}' not found in '{}' (request by '{}')", new Object[]{name, this.getSimpleName(), this.nameOf(requestor), ignore});
                }
            } else if (result.getClassLoader().equals(this.dependencyClassLoader) && !this.equals(requestor)) {
                result = null;
            }
        }
        if (result == null && this.equals(requestor)) {
            if (this.dependencyClassLoader != null) {
                try {
                    result = this.dependencyClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException ignore) {
                    LOG.trace("Class '{}' not found as dependency of '{}'", new Object[]{name, this.getSimpleName(), ignore});
                }
            }
            if (result == null) {
                result = this.dependencyResolver.findClass(requestor, name);
            }
        }
        return result;
    }

    @Override
    public URL findResource(DependencyResolver requestor, String name) {
        Require.nonNull(name, "name");
        LOG.debug("{}.findResourceFor(<{}>, '{}')", new Object[]{this.getSimpleName(), this.nameOf(requestor), name});
        URL url = super.findResource(name);
        if (url == null && this.equals(requestor)) {
            if (this.dependencyClassLoader != null) {
                url = this.dependencyClassLoader.findResource(name);
            }
            if (url == null) {
                url = this.dependencyResolver.findResource(requestor, name);
            }
        }
        return url;
    }

    @Override
    public void findResources(DependencyResolver requestor, String name, Collection<URL> target) throws IOException {
        Require.nonNull(name, "name");
        LOG.debug("{}.findResourcesFor(<{}>, '{}')", new Object[]{this.getSimpleName(), this.nameOf(requestor), name});
        Enumeration<URL> selfResult = super.findResources(name);
        this.addAll(target, selfResult);
        if (this.equals(requestor)) {
            if (this.dependencyClassLoader != null) {
                Enumeration<URL> dependencyResult = this.dependencyClassLoader.findResources(name);
                this.addAll(target, dependencyResult);
            }
            this.dependencyResolver.findResources(requestor, name, target);
        }
    }

    private <T> void addAll(Collection<T> target, Enumeration<T> elements) {
        while (elements.hasMoreElements()) {
            target.add(elements.nextElement());
        }
    }

    public final String toString() {
        return "PluginClassLoader[" + this.simpleName + "]";
    }

    private String nameOf(DependencyResolver requestor) {
        return requestor == null ? "application" : requestor.getSimpleName();
    }

    @Override
    public final void close() throws IOException {
        Closeables.close(() -> super.close(), this.dependencyClassLoader);
    }

    private final class PluginInformationImpl
    implements PluginInformation {
        private PluginInformationImpl() {
        }

        @Override
        public final URL getLocation() {
            return PluginClassLoader.this.self;
        }

        @Override
        public final ClassLoader getClassLoader() {
            return PluginClassLoader.this;
        }

        @Override
        public final Manifest getManifest() {
            return PluginClassLoader.this.manifest;
        }

        public final String toString() {
            return PluginClassLoader.this.getSimpleName();
        }

        public final int hashCode() {
            return PluginClassLoader.this.self.toString().hashCode();
        }

        public final boolean equals(Object obj) {
            return obj == this || obj instanceof PluginInformation && ((PluginInformation)obj).getLocation().toString().equals(this.getLocation().toString());
        }
    }

    final class DependencyClassLoader
    extends URLClassLoader {
        private DependencyClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        final String getPluginName() {
            return PluginClassLoader.this.getSimpleName();
        }

        public String toString() {
            return "DependencyClassLoader[" + PluginClassLoader.this.getSimpleName() + "]";
        }
    }
}

