/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.internal;

import de.skuzzle.tinyplugz.TinyPlugz;
import de.skuzzle.tinyplugz.TinyPlugzException;
import de.skuzzle.tinyplugz.internal.DefaultTinyPlugz;
import de.skuzzle.tinyplugz.internal.ServiceLoaderWrapper;
import de.skuzzle.tinyplugz.util.ElementIterator;
import de.skuzzle.tinyplugz.util.ReflectionUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TinyPlugzLookUp {
    SPI_STRATEGY{

        @Override
        public TinyPlugz getInstance(ClassLoader classLoader, ServiceLoaderWrapper serviceLoader, Map<Object, Object> props) {
            TinyPlugz impl;
            ElementIterator<TinyPlugz> providers = serviceLoader.loadService(TinyPlugz.class, classLoader);
            TinyPlugz tinyPlugz = impl = providers.hasNext() ? (TinyPlugz)providers.next() : DEFAULT_INSTANCE_STRATEGY.getInstance(classLoader, serviceLoader, props);
            if (providers.hasNext()) {
                boolean fail;
                boolean bl = fail = props.get("tinyplugz.failOnMultipleProviders") != null;
                if (fail) {
                    throw new TinyPlugzException("There are multiple TinyPlugz providers");
                }
                LOG.warn("Multiple TinyPlugz bindings found on class path");
                providers.forEachRemaining(provider -> LOG.debug("Ignoring TinyPlugz provider '{}'", (Object)provider.getClass().getName()));
            }
            return impl;
        }
    }
    ,
    DEFAULT_INSTANCE_STRATEGY{

        @Override
        public TinyPlugz getInstance(ClassLoader classLoader, ServiceLoaderWrapper serviceLoader, Map<Object, Object> props) {
            return new DefaultTinyPlugz();
        }
    }
    ,
    STATIC_STRATEGY{

        @Override
        public TinyPlugz getInstance(ClassLoader classLoader, ServiceLoaderWrapper serviceLoader, Map<Object, Object> props) {
            Object value = props.get("tinyplugz.forceImplementation");
            return ReflectionUtil.createInstance(value, TinyPlugz.class, classLoader);
        }
    };

    private static final Logger LOG;

    public final TinyPlugz getInstance(ClassLoader classLoader, Map<Object, Object> props) {
        ServiceLoaderWrapper serviceLoader = ServiceLoaderWrapper.getDefault();
        return this.getInstance(classLoader, serviceLoader, props);
    }

    public abstract TinyPlugz getInstance(ClassLoader var1, ServiceLoaderWrapper var2, Map<Object, Object> var3);

    static {
        LOG = LoggerFactory.getLogger(TinyPlugzLookUp.class);
    }
}

