/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Closeables {
    private static final Logger LOG = LoggerFactory.getLogger(Closeables.class);

    private Closeables() {
    }

    public static void close(Closeable ... closeables) throws IOException {
        Closeables.close(Arrays.asList(closeables));
    }

    public static void close(Iterable<? extends Closeable> closeables) throws IOException {
        IOException first = null;
        for (Closeable closeable : closeables) {
            if (closeable == null) {
                LOG.debug("trying to call .close() on null reference");
                continue;
            }
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (first == null) {
                    first = e;
                    continue;
                }
                first.addSuppressed(e);
            }
        }
        if (first != null) {
            throw first;
        }
    }

    public static boolean safeClose(Closeable c) {
        if (c == null) {
            LOG.debug("trying to call .close() on null reference");
            return true;
        }
        try {
            c.close();
            return true;
        }
        catch (IOException e) {
            LOG.error("Error while closing '{}': ", (Object)c, (Object)e);
            return false;
        }
    }

    public static boolean safeCloseAll(Closeable ... closeables) {
        boolean result = true;
        for (Closeable c : closeables) {
            result &= Closeables.safeClose(c);
        }
        return result;
    }

    public static boolean safeCloseAll(Iterable<? extends Closeable> closeables) {
        Iterator<? extends Closeable> it = closeables.iterator();
        boolean result = true;
        while (it.hasNext()) {
            result &= Closeables.safeClose(it.next());
        }
        return result;
    }
}

