/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.util;

import de.skuzzle.tinyplugz.util.Require;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;

public interface ElementIterator<T>
extends Iterator<T>,
Enumeration<T> {
    public static <T> @NonNull ElementIterator<T> wrap(final Iterator<T> iterator) {
        Require.nonNull(iterator, "iterator");
        if (iterator instanceof ElementIterator) {
            return (ElementIterator)iterator;
        }
        return new ElementIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    public static <T> @NonNull ElementIterator<T> wrap(final Enumeration<T> enumeration) {
        Require.nonNull(enumeration, "enumeration");
        if (enumeration instanceof ElementIterator) {
            return (ElementIterator)enumeration;
        }
        return new ElementIterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }
        };
    }

    @Override
    default public boolean hasMoreElements() {
        return this.hasNext();
    }

    @Override
    default public T nextElement() {
        return (T)this.next();
    }
}

