/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.util;

import de.skuzzle.tinyplugz.TinyPlugz;
import de.skuzzle.tinyplugz.util.Require;
import org.eclipse.jdt.annotation.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExchangeClassLoader
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ExchangeClassLoader.class);
    private final ClassLoader backupCl;
    private final ClassLoader exchangeCl;
    private boolean failOnChange;

    private ExchangeClassLoader(ClassLoader classLoader) {
        this.exchangeCl = classLoader;
        this.backupCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.exchangeCl);
    }

    public static ExchangeClassLoader with(@NonNull ClassLoader classLoader) {
        Require.nonNull(classLoader, "classLoader");
        return new ExchangeClassLoader(classLoader);
    }

    public static ExchangeClassLoader forTinyPlugz() {
        if (TinyPlugz.isDeployed()) {
            return new ExchangeClassLoader(TinyPlugz.getInstance().getClassLoader());
        }
        return new ExchangeClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public void setFailOnChange(boolean failOnChange) {
        this.failOnChange = failOnChange;
    }

    @Override
    public final void close() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.backupCl);
        if (!current.equals(this.exchangeCl)) {
            LOG.warn("Detected 3rd party ClassLoader exchange");
            Require.state(!this.failOnChange, "Detected 3rd party ClassLoader exchange", new Object[0]);
        }
    }
}

