/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.util;

import de.skuzzle.tinyplugz.util.ElementIterator;
import de.skuzzle.tinyplugz.util.Require;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class Iterators {
    private Iterators() {
    }

    public static <T> Iterator<T> singleIterator(T t) {
        Require.nonNull(t, "t");
        return Collections.singleton(t).iterator();
    }

    public static <T> Iterable<T> iterableOf(Iterator<T> it) {
        final Iterator<T> theIt = Require.nonNull(it, "it");
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return theIt;
            }
        };
    }

    @SafeVarargs
    public static <T> ElementIterator<T> composite(Iterator<T> ... iterators) {
        Iterator result;
        Require.nonNull(iterators, "iterators");
        if (iterators.length == 0) {
            result = Collections.emptyIterator();
        } else if (iterators.length == 1) {
            if (iterators[0] instanceof ElementIterator) {
                return (ElementIterator)iterators[0];
            }
            result = iterators[0];
        } else {
            result = new CompoundIterator((Iterator[])iterators);
        }
        return ElementIterator.wrap(result);
    }

    @SafeVarargs
    public static <T> Iterable<T> composite(Iterable<T> ... iterables) {
        Iterator it;
        Require.nonNull(iterables, "iterables");
        if (iterables.length == 0) {
            it = Collections.emptyIterator();
        } else {
            if (iterables.length == 1) {
                return iterables[0];
            }
            Iterator[] iterators = (Iterator[])Arrays.stream(iterables).map(Iterable::iterator).toArray(Iterator[]::new);
            it = new CompoundIterator(iterators);
        }
        return Iterators.iterableOf(it);
    }

    private static final class CompoundIterator<E>
    implements ElementIterator<E> {
        private final Iterator<E>[] iterators;
        private int i;

        @SafeVarargs
        private CompoundIterator(Iterator<E> ... iterators) {
            this.iterators = iterators;
        }

        @Override
        public boolean hasNext() {
            while (this.i < this.iterators.length) {
                Iterator<E> nextEnum = this.iterators[this.i];
                if (nextEnum.hasNext()) {
                    return true;
                }
                ++this.i;
            }
            return false;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                Iterator<E> nextIt = this.iterators[this.i];
                return nextIt.next();
            }
            throw new NoSuchElementException();
        }
    }
}

