/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class LazyMap<K, V>
implements Map<K, V> {
    private final Supplier<Map<K, V>> supp;
    private Map<K, V> back;

    public static <K, V> Map<K, V> forMap(Supplier<Map<K, V>> noArgCtor) {
        if (noArgCtor == null) {
            throw new IllegalArgumentException("noArgCtor is null");
        }
        return new LazyMap<K, V>(noArgCtor);
    }

    public LazyMap(Supplier<Map<K, V>> supp) {
        this.supp = supp;
    }

    private Map<K, V> ensureInit() {
        if (this.back == null) {
            this.back = this.createBackend();
        }
        return this.back;
    }

    private Map<K, V> createBackend() {
        return this.supp.get();
    }

    @Override
    public int size() {
        return this.back == null ? 0 : this.back.size();
    }

    @Override
    public boolean isEmpty() {
        return this.back == null ? false : this.back.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.back == null ? false : this.back.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.back == null ? false : this.back.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.back == null ? null : (V)this.back.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.ensureInit().put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.back == null ? null : (V)this.back.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.ensureInit().putAll(m);
    }

    @Override
    public void clear() {
        if (this.back == null) {
            return;
        }
        this.back.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.back == null ? Collections.emptySet() : this.back.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.back == null ? Collections.emptyList() : this.back.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.back == null ? Collections.emptySet() : this.back.entrySet();
    }

    @Override
    public int hashCode() {
        return this.back == null ? Collections.emptyMap().hashCode() : this.back.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        return this.isEmpty() ? other.isEmpty() : this.back.equals(other);
    }
}

