/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.util;

import de.skuzzle.tinyplugz.TinyPlugzException;
import de.skuzzle.tinyplugz.util.Require;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static <T> T createInstance(Object source, Class<T> base, ClassLoader classLoader) {
        Require.nonNull(source, "source");
        Require.nonNull(base, "base");
        Require.nonNull(classLoader, "classLoader");
        if (source instanceof Class) {
            return ReflectionUtil.fromClass(base, (Class)source);
        }
        if (source instanceof String) {
            try {
                Class<?> concrete = classLoader.loadClass(source.toString());
                return ReflectionUtil.fromClass(base, concrete);
            }
            catch (ClassNotFoundException e) {
                throw new TinyPlugzException(e);
            }
        }
        if (base.isInstance(source)) {
            return base.cast(source);
        }
        throw new TinyPlugzException(String.format("'%s' is not valid for '%s'", source, base.getName()));
    }

    private static <T> T fromClass(Class<T> base, Class<?> concrete) {
        if (!base.isAssignableFrom(concrete)) {
            throw new TinyPlugzException(String.format("'%s' is not an instance of '%s'", concrete.getName(), base.getName()));
        }
        try {
            Constructor<?> ctor = concrete.getConstructor(new Class[0]);
            ctor.setAccessible(true);
            return base.cast(ctor.newInstance(new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new TinyPlugzException(e);
        }
    }
}

