/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.tinyplugz.util;

import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class Require {
    private Require() {
    }

    public static <T> @NonNull T nonNull(@Nullable T obj, String paramName) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("'%s' must not be null", paramName));
        }
        return obj;
    }

    public static <T> @NonNull T nonNull(@Nullable T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("encountered illegal null value");
        }
        return obj;
    }

    public static void condition(boolean condition, String message, Object ... format) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, format));
        }
    }

    public static void state(boolean state, String message, Object ... format) {
        if (!state) {
            throw new IllegalStateException(String.format(message, format));
        }
    }

    public static <T extends Exception> void state(boolean state, Function<String, T> excpetionCtor, String message, Object format) throws T {
        if (!state) {
            throw (Exception)excpetionCtor.apply(String.format(message, format));
        }
    }

    public static <T> @NonNull T nonNullResult(@Nullable T result, String call) {
        if (result == null) {
            throw new IllegalStateException(String.format("call of '%s' yielded unexpected null value", call));
        }
        return result;
    }
}

