/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain;

public enum CompressionAlgorithm {
    None,
    Gzip;


    public static CompressionAlgorithm parseValue(int value) {
        switch (value) {
            case 0: {
                return None;
            }
            case 1: {
                return Gzip;
            }
        }
        throw new IllegalArgumentException(String.format("Value %d is not a valid CompressionAlgorithm", value));
    }

    public static int getIntValue(CompressionAlgorithm algorithm) {
        switch (algorithm) {
            case None: {
                return 0;
            }
            case Gzip: {
                return 1;
            }
        }
        throw new IllegalArgumentException(String.format("Value %s is not a valid CompressionAlgorithm", new Object[]{algorithm}));
    }
}

