/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain;

import de.slackspace.openkeepass.domain.Entry;
import de.slackspace.openkeepass.domain.GroupContract;
import de.slackspace.openkeepass.domain.KeePassFileElement;
import de.slackspace.openkeepass.domain.Times;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(strict=false, name="Group")
public class Group
implements KeePassFileElement {
    @Element(name="UUID", required=false)
    private UUID uuid;
    @Element(name="Name", required=false)
    private String name;
    @Element(name="IconID", required=false)
    private int iconId = 49;
    private transient byte[] iconData;
    @Element(name="CustomIconUUID", required=false)
    private UUID customIconUUID;
    @Element(name="Times", required=false)
    private Times times;
    @Element(name="IsExpanded", required=false)
    private Boolean isExpanded;
    @ElementList(name="Entry", inline=true, required=false)
    private List<Entry> entries = new ArrayList<Entry>();
    @ElementList(name="Group", inline=true, required=false)
    private List<Group> groups = new ArrayList<Group>();

    Group() {
        this.uuid = UUID.randomUUID();
    }

    public Group(GroupContract groupContract) {
        this.entries = groupContract.getEntries();
        this.groups = groupContract.getGroups();
        this.iconId = groupContract.getIconId();
        this.isExpanded = groupContract.isExpanded();
        this.name = groupContract.getName();
        this.times = groupContract.getTimes();
        this.uuid = groupContract.getUuid();
        this.iconData = groupContract.getIconData();
        this.customIconUUID = groupContract.getCustomIconUuid();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public Entry getEntryByTitle(String title) {
        for (Entry entry : this.entries) {
            if (!entry.getTitle().equalsIgnoreCase(title)) continue;
            return entry;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public int getIconId() {
        return this.iconId;
    }

    public UUID getCustomIconUuid() {
        return this.customIconUUID;
    }

    public byte[] getIconData() {
        return this.iconData;
    }

    public Times getTimes() {
        return this.times;
    }

    public boolean isExpanded() {
        if (this.isExpanded == null) {
            return false;
        }
        return this.isExpanded;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.customIconUUID == null ? 0 : this.customIconUUID.hashCode());
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        result = 31 * result + (this.groups == null ? 0 : this.groups.hashCode());
        result = 31 * result + this.iconId;
        result = 31 * result + (this.isExpanded == null ? 0 : this.isExpanded.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.times == null ? 0 : this.times.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group)obj;
        if (this.customIconUUID == null ? other.customIconUUID != null : !this.customIconUUID.equals(other.customIconUUID)) {
            return false;
        }
        if (this.entries == null ? other.entries != null : !this.entries.equals(other.entries)) {
            return false;
        }
        if (this.groups == null ? other.groups != null : !this.groups.equals(other.groups)) {
            return false;
        }
        if (this.iconId != other.iconId) {
            return false;
        }
        if (this.isExpanded == null ? other.isExpanded != null : !this.isExpanded.equals(other.isExpanded)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.times == null ? other.times != null : !this.times.equals(other.times)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }
}

