/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain;

import de.slackspace.openkeepass.domain.Entry;
import de.slackspace.openkeepass.domain.Group;
import de.slackspace.openkeepass.domain.KeePassFileContract;
import de.slackspace.openkeepass.domain.KeePassFileElement;
import de.slackspace.openkeepass.domain.Meta;
import de.slackspace.openkeepass.domain.filter.Filter;
import de.slackspace.openkeepass.domain.filter.ListFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(strict=false, name="KeePassFile")
public class KeePassFile
implements KeePassFileElement {
    @Element(name="Meta")
    private Meta meta;
    @Element(name="Root")
    private Group root;

    KeePassFile() {
    }

    public KeePassFile(KeePassFileContract keePassFileContract) {
        this.meta = keePassFileContract.getMeta();
        this.root = keePassFileContract.getRoot();
    }

    public Meta getMeta() {
        return this.meta;
    }

    public Group getRoot() {
        return this.root;
    }

    public List<Group> getTopGroups() {
        if (this.root != null && this.root.getGroups() != null && this.root.getGroups().size() == 1) {
            return this.root.getGroups().get(0).getGroups();
        }
        return new ArrayList<Group>();
    }

    public List<Entry> getTopEntries() {
        if (this.root != null && this.root.getGroups() != null && this.root.getGroups().size() == 1) {
            return this.root.getGroups().get(0).getEntries();
        }
        return new ArrayList<Entry>();
    }

    public Entry getEntryByTitle(String title) {
        List<Entry> entries = this.getEntriesByTitle(title, true);
        if (!entries.isEmpty()) {
            return entries.get(0);
        }
        return null;
    }

    public List<Entry> getEntriesByTitle(final String title, final boolean matchExactly) {
        ArrayList<Entry> allEntries = new ArrayList<Entry>();
        if (this.root != null) {
            this.getEntries(this.root, allEntries);
        }
        return ListFilter.filter(allEntries, new Filter<Entry>(){

            @Override
            public boolean matches(Entry item) {
                return matchExactly ? item.getTitle() != null && item.getTitle().equalsIgnoreCase(title) : item.getTitle() != null && item.getTitle().toLowerCase().contains(title.toLowerCase());
            }
        });
    }

    public List<Group> getGroupsByName(final String name, final boolean matchExactly) {
        ArrayList<Group> allGroups = new ArrayList<Group>();
        if (this.root != null) {
            this.getGroups(this.root, allGroups);
        }
        return ListFilter.filter(allGroups, new Filter<Group>(){

            @Override
            public boolean matches(Group item) {
                return matchExactly ? item.getName() != null && item.getName().equalsIgnoreCase(name) : item.getName() != null && item.getName().toLowerCase().contains(name.toLowerCase());
            }
        });
    }

    public List<Entry> getEntries() {
        ArrayList<Entry> allEntries = new ArrayList<Entry>();
        if (this.root != null) {
            this.getEntries(this.root, allEntries);
        }
        return allEntries;
    }

    public List<Group> getGroups() {
        ArrayList<Group> allGroups = new ArrayList<Group>();
        if (this.root != null) {
            this.getGroups(this.root, allGroups);
        }
        return allGroups;
    }

    public Group getGroupByName(String name) {
        List<Group> groups = this.getGroupsByName(name, true);
        if (!groups.isEmpty()) {
            return groups.get(0);
        }
        return null;
    }

    private void getEntries(Group parentGroup, List<Entry> entries) {
        List<Group> groups = parentGroup.getGroups();
        entries.addAll(parentGroup.getEntries());
        if (!groups.isEmpty()) {
            for (Group group : groups) {
                this.getEntries(group, entries);
            }
        }
    }

    private void getGroups(Group parentGroup, List<Group> groups) {
        List<Group> parentGroups = parentGroup.getGroups();
        groups.addAll(parentGroups);
        if (!parentGroups.isEmpty()) {
            for (Group group : parentGroups) {
                this.getGroups(group, groups);
            }
        }
    }

    public Entry getEntryByUUID(final UUID UUID2) {
        List<Entry> allEntries = this.getEntries();
        List<Entry> entries = ListFilter.filter(allEntries, new Filter<Entry>(){

            @Override
            public boolean matches(Entry item) {
                return item.getUuid() != null && item.getUuid().compareTo(UUID2) == 0;
            }
        });
        if (entries.size() == 1) {
            return entries.get(0);
        }
        return null;
    }

    public Group getGroupByUUID(final UUID UUID2) {
        List<Group> allGroups = this.getGroups();
        List<Group> groups = ListFilter.filter(allGroups, new Filter<Group>(){

            @Override
            public boolean matches(Group item) {
                return item.getUuid() != null && item.getUuid().compareTo(UUID2) == 0;
            }
        });
        if (groups.size() == 1) {
            return groups.get(0);
        }
        return null;
    }
}

