/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class VariantDictionary {
    private static final String UTF_8 = "UTF-8";
    private static final int VDM_CRITICAL = 65280;
    private static final int VDM_VERSION = 256;
    private static final int UINT32 = 4;
    private static final int UINT64 = 5;
    private static final int BOOLEAN = 8;
    private static final int INT32 = 12;
    private static final int INT64 = 13;
    private static final int STRING = 24;
    private static final int BYTE_ARRAY = 66;
    private Map<String, Object> map = new HashMap<String, Object>();

    public VariantDictionary(byte[] bytes) {
        byte btType;
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        short version = buffer.getShort();
        if (!this.isVersionSupported(version)) {
            throw new UnsupportedOperationException("Cannot read Kdf parameters. A newer version is required to open this keepass file.");
        }
        while ((btType = buffer.get()) != 0) {
            int nameLength = buffer.getInt();
            byte[] nameBytes = new byte[nameLength];
            buffer.get(nameBytes, 0, nameLength);
            String cbName = new String(nameBytes, Charset.forName(UTF_8));
            int valueLength = buffer.getInt();
            byte[] pbValue = new byte[valueLength];
            buffer.get(pbValue, 0, valueLength);
            switch (btType) {
                case 66: {
                    this.map.put(cbName, pbValue);
                    break;
                }
                case 4: {
                    int pbValueUInt = ByteBuffer.wrap(pbValue).order(ByteOrder.LITTLE_ENDIAN).getInt();
                    this.map.put(cbName, pbValueUInt);
                    break;
                }
                case 5: {
                    long pbValueULong = ByteBuffer.wrap(pbValue).order(ByteOrder.LITTLE_ENDIAN).getLong();
                    this.map.put(cbName, pbValueULong);
                    break;
                }
                case 8: {
                    boolean pbValueBool = pbValue[0] != 0;
                    this.map.put(cbName, pbValueBool);
                    break;
                }
                case 12: {
                    int pbValueInt = ByteBuffer.wrap(pbValue).order(ByteOrder.LITTLE_ENDIAN).getInt();
                    this.map.put(cbName, pbValueInt);
                    break;
                }
                case 13: {
                    long pbValueLong = ByteBuffer.wrap(pbValue).order(ByteOrder.LITTLE_ENDIAN).getLong();
                    this.map.put(cbName, pbValueLong);
                    break;
                }
                case 24: {
                    String pbValueString = new String(pbValue, Charset.forName(UTF_8));
                    this.map.put(cbName, pbValueString);
                }
            }
        }
    }

    private boolean isVersionSupported(int version) {
        return (version & 0xFF00) <= 256;
    }

    public byte[] getByteArray(String key) {
        return (byte[])this.map.get(key);
    }

    public int getInt(String key) {
        return (Integer)this.map.get(key);
    }

    public long getLong(String key) {
        return (Long)this.map.get(key);
    }
}

