/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.processor;

import de.slackspace.openkeepass.domain.Entry;
import de.slackspace.openkeepass.domain.Group;
import de.slackspace.openkeepass.domain.KeePassFile;
import de.slackspace.openkeepass.domain.Property;
import de.slackspace.openkeepass.domain.zipper.GroupZipper;
import de.slackspace.openkeepass.util.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;

public class ReferencesEnricher {
    public KeePassFile enrichNodesWithReferences(KeePassFile keePassFile) {
        GroupZipper zipper = new GroupZipper(keePassFile);
        Iterator<Group> iter = zipper.iterator();
        while (iter.hasNext()) {
            Group group = iter.next();
            this.enrichEntriesWithReferences(group, keePassFile);
        }
        return zipper.close();
    }

    private void enrichEntriesWithReferences(Group group, KeePassFile keePassFile) {
        List<Entry> entries = group.getEntries();
        for (Entry entry : entries) {
            for (Property property : entry.getProperties()) {
                UUID uuid;
                Entry referenceEntry;
                String value = property.getValue();
                if (!this.isUUIDReference(value) || (referenceEntry = keePassFile.getEntryByUUID(uuid = this.getUUID(value))) == null) continue;
                String referenceValue = this.getValueFromReferenceEntry(value, referenceEntry);
                entry.getReferencedProperties().add(new Property(property.getKey(), referenceValue, false));
            }
        }
    }

    private String getValueFromReferenceEntry(String reference, Entry referenceEntry) {
        String field = this.getReferenceField(reference);
        if ("A".equals(field)) {
            return referenceEntry.getUrl();
        }
        if ("P".equals(field)) {
            return referenceEntry.getPassword();
        }
        if ("U".equals(field)) {
            return referenceEntry.getUsername();
        }
        if ("N".equals(field)) {
            return referenceEntry.getNotes();
        }
        if ("T".equals(field)) {
            return referenceEntry.getTitle();
        }
        return reference;
    }

    private boolean isUUIDReference(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        return Entry.REFERENCE_PATTERN.matcher(value).matches();
    }

    private UUID getUUID(String value) {
        Matcher matcher = Entry.REFERENCE_PATTERN.matcher(value);
        matcher.find();
        String uuidString = StringUtils.convertToUUIDString(matcher.group(2));
        return UUID.fromString(uuidString);
    }

    private String getReferenceField(String value) {
        Matcher matcher = Entry.REFERENCE_PATTERN.matcher(value);
        matcher.find();
        return matcher.group(1);
    }
}

