/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.util;

import java.io.IOException;
import java.io.InputStream;

public class SafeInputStream
extends InputStream {
    private InputStream inputStream;

    public SafeInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void readSafe(byte[] buf) throws IOException {
        int readBytes = this.inputStream.read(buf);
        if (readBytes == -1) {
            throw new IOException("Could not read any bytes from stream");
        }
    }

    public void skipSafe(long numBytes) throws IOException {
        long skippedBytes = this.inputStream.skip(numBytes);
        if (skippedBytes == -1L) {
            throw new IOException("Could not skip '" + numBytes + "' bytes in stream");
        }
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }
}

