/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass;

import de.slackspace.openkeepass.api.KeePassDatabaseReader;
import de.slackspace.openkeepass.api.KeePassDatabaseWriter;
import de.slackspace.openkeepass.api.KeyFileReader;
import de.slackspace.openkeepass.crypto.Sha256;
import de.slackspace.openkeepass.domain.KeePassFile;
import de.slackspace.openkeepass.domain.KeePassHeader;
import de.slackspace.openkeepass.exception.KeePassDatabaseUnreadableException;
import de.slackspace.openkeepass.util.ByteUtils;
import de.slackspace.openkeepass.util.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class KeePassDatabase {
    private static final String UTF_8 = "UTF-8";
    private static final String MSG_UTF8_NOT_SUPPORTED = "The encoding UTF-8 is not supported";
    private static final String MSG_EMPTY_MASTER_KEY = "The password for the database must not be null. Please provide a valid password.";
    private KeePassHeader keepassHeader = new KeePassHeader();
    private byte[] keepassFile;

    private KeePassDatabase(InputStream inputStream) {
        try {
            this.keepassFile = StreamUtils.toByteArray(inputStream);
            this.keepassHeader.checkVersionSupport(this.keepassFile);
            this.keepassHeader.read(this.keepassFile);
        }
        catch (IOException e) {
            throw new KeePassDatabaseUnreadableException("Could not open database file", e);
        }
    }

    public static KeePassDatabase getInstance(String keePassDatabaseFile) {
        return KeePassDatabase.getInstance(new File(keePassDatabaseFile));
    }

    public static KeePassDatabase getInstance(File keePassDatabaseFile) {
        if (keePassDatabaseFile == null) {
            throw new IllegalArgumentException("You must provide a valid KeePass database file.");
        }
        FileInputStream keePassDatabaseStream = null;
        try {
            keePassDatabaseStream = new FileInputStream(keePassDatabaseFile);
            KeePassDatabase keePassDatabase = KeePassDatabase.getInstance(keePassDatabaseStream);
            return keePassDatabase;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The KeePass database file could not be found. You must provide a valid KeePass database file.", e);
        }
        finally {
            if (keePassDatabaseStream != null) {
                try {
                    ((InputStream)keePassDatabaseStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static KeePassDatabase getInstance(InputStream keePassDatabaseStream) {
        if (keePassDatabaseStream == null) {
            throw new IllegalArgumentException("You must provide a non-empty KeePass database stream.");
        }
        return new KeePassDatabase(keePassDatabaseStream);
    }

    public KeePassFile openDatabase(String password) {
        if (password == null) {
            throw new IllegalArgumentException(MSG_EMPTY_MASTER_KEY);
        }
        try {
            byte[] passwordBytes = password.getBytes(UTF_8);
            byte[] hashedPassword = Sha256.hash(passwordBytes);
            return new KeePassDatabaseReader(this.keepassHeader).decryptAndParseDatabase(hashedPassword, this.keepassFile);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(MSG_UTF8_NOT_SUPPORTED, e);
        }
    }

    public KeePassFile openDatabase(String password, File keyFile) {
        if (password == null) {
            throw new IllegalArgumentException(MSG_EMPTY_MASTER_KEY);
        }
        if (keyFile == null) {
            throw new IllegalArgumentException("You must provide a valid KeePass keyfile.");
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(keyFile);
            KeePassFile keePassFile = this.openDatabase(password, inputStream);
            return keePassFile;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The KeePass keyfile could not be found. You must provide a valid KeePass keyfile.", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public KeePassFile openDatabase(String password, InputStream keyFileStream) {
        if (password == null) {
            throw new IllegalArgumentException(MSG_EMPTY_MASTER_KEY);
        }
        if (keyFileStream == null) {
            throw new IllegalArgumentException("You must provide a non-empty KeePass keyfile stream.");
        }
        try {
            byte[] passwordBytes = password.getBytes(UTF_8);
            byte[] hashedPassword = Sha256.hash(passwordBytes);
            byte[] protectedBuffer = new KeyFileReader().readKeyFile(keyFileStream);
            return new KeePassDatabaseReader(this.keepassHeader).decryptAndParseDatabase(ByteUtils.concat(hashedPassword, protectedBuffer), this.keepassFile);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(MSG_UTF8_NOT_SUPPORTED, e);
        }
    }

    public KeePassFile openDatabase(File keyFile) {
        if (keyFile == null) {
            throw new IllegalArgumentException("You must provide a valid KeePass keyfile.");
        }
        try {
            return this.openDatabase(new FileInputStream(keyFile));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("The KeePass keyfile could not be found. You must provide a valid KeePass keyfile.", e);
        }
    }

    public KeePassFile openDatabase(InputStream keyFileStream) {
        if (keyFileStream == null) {
            throw new IllegalArgumentException("You must provide a non-empty KeePass keyfile stream.");
        }
        byte[] protectedBuffer = new KeyFileReader().readKeyFile(keyFileStream);
        return new KeePassDatabaseReader(this.keepassHeader).decryptAndParseDatabase(protectedBuffer, this.keepassFile);
    }

    public KeePassHeader getHeader() {
        return this.keepassHeader;
    }

    public static void write(KeePassFile keePassFile, String password, String keePassDatabaseFile) {
        if (keePassDatabaseFile == null || keePassDatabaseFile.isEmpty()) {
            throw new IllegalArgumentException("You must provide a non-empty path where the database should be written to.");
        }
        try {
            KeePassDatabase.write(keePassFile, password, new FileOutputStream(keePassDatabaseFile));
        }
        catch (FileNotFoundException e) {
            throw new KeePassDatabaseUnreadableException("Could not find database file", e);
        }
    }

    public static void write(KeePassFile keePassFile, String password, OutputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("You must provide a stream to write to.");
        }
        new KeePassDatabaseWriter().writeKeePassFile(keePassFile, password, stream);
    }
}

