/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain;

import de.slackspace.openkeepass.domain.BinaryContract;
import de.slackspace.openkeepass.exception.AttachmentUnreadableException;
import de.slackspace.openkeepass.exception.AttachmentUnwriteableException;
import de.slackspace.openkeepass.util.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Text;

@Root(strict=false, name="Binary")
public class Binary {
    @Attribute(name="ID")
    private int id;
    @Attribute(name="Compressed")
    private Boolean isCompressed;
    @Text
    private byte[] data;

    Binary() {
    }

    public Binary(BinaryContract binaryContract) {
        this.id = binaryContract.getId();
        this.isCompressed = binaryContract.isCompressed();
        this.data = this.isCompressed != false ? this.compressData(binaryContract) : binaryContract.getData();
    }

    public int getId() {
        return this.id;
    }

    public boolean isCompressed() {
        if (this.isCompressed == null) {
            return false;
        }
        return this.isCompressed;
    }

    public byte[] getData() {
        if (this.isCompressed()) {
            return this.decompressData();
        }
        return this.data;
    }

    private byte[] decompressData() {
        GZIPInputStream gzipInputStream = null;
        try {
            byte[] decompressed;
            gzipInputStream = new GZIPInputStream(new ByteArrayInputStream(this.data));
            byte[] byArray = decompressed = StreamUtils.toByteArray(gzipInputStream);
            return byArray;
        }
        catch (IOException e) {
            throw new AttachmentUnreadableException("Could not read attachment from resource with id '" + this.id + "'", e);
        }
        finally {
            try {
                if (gzipInputStream != null) {
                    gzipInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private byte[] compressData(BinaryContract binaryContract) {
        if (binaryContract.getData() == null) {
            return null;
        }
        try {
            ByteArrayOutputStream streamToZip = new ByteArrayOutputStream();
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(streamToZip);
            gzipOutputStream.write(binaryContract.getData());
            gzipOutputStream.close();
            return streamToZip.toByteArray();
        }
        catch (IOException e) {
            throw new AttachmentUnwriteableException("Could not compress attachment with id '" + binaryContract.getId() + "'");
        }
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        result = 31 * result + this.id;
        result = 31 * result + (this.isCompressed == null ? 0 : this.isCompressed.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Binary)) {
            return false;
        }
        Binary other = (Binary)obj;
        if (this.id != other.id) {
            return false;
        }
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        return !(this.isCompressed == null ? other.isCompressed != null : !this.isCompressed.equals(other.isCompressed));
    }
}

