/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.domain.xml.adapter;

import de.slackspace.openkeepass.domain.PropertyValue;
import de.slackspace.openkeepass.processor.ProtectionStrategy;
import org.simpleframework.xml.convert.Converter;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

public class PropertyValueXmlAdapter
implements Converter<PropertyValue> {
    private ProtectionStrategy strategy;

    public PropertyValueXmlAdapter(ProtectionStrategy protectionStrategy) {
        this.strategy = protectionStrategy;
    }

    public PropertyValue read(InputNode node) throws Exception {
        String value = node.getValue();
        if (value == null) {
            return new PropertyValue(false, "");
        }
        if (this.isProtected(node)) {
            String rawValue = this.strategy.apply(value);
            return new PropertyValue(true, rawValue);
        }
        return new PropertyValue(false, value);
    }

    private boolean isProtected(InputNode node) throws Exception {
        InputNode isProtectedNode = node.getAttribute("Protected");
        if (isProtectedNode == null) {
            return false;
        }
        String value = isProtectedNode.getValue();
        return value.equalsIgnoreCase("true");
    }

    public void write(OutputNode node, PropertyValue value) throws Exception {
    }
}

