/*
 * Decompiled with CFR 0.152.
 */
package de.slackspace.openkeepass.processor;

import de.slackspace.openkeepass.domain.Attachment;
import de.slackspace.openkeepass.domain.Binaries;
import de.slackspace.openkeepass.domain.Binary;
import de.slackspace.openkeepass.domain.Entry;
import de.slackspace.openkeepass.domain.EntryBuilder;
import de.slackspace.openkeepass.domain.Group;
import de.slackspace.openkeepass.domain.KeePassFile;
import de.slackspace.openkeepass.domain.zipper.GroupZipper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BinaryEnricher {
    public KeePassFile enrichNodesWithBinaryData(KeePassFile keePassFile) {
        Binaries binaryLibrary = keePassFile.getMeta().getBinaries();
        GroupZipper zipper = new GroupZipper(keePassFile);
        Iterator<Group> iter = zipper.iterator();
        while (iter.hasNext()) {
            Group group = iter.next();
            this.enrichEntriesWithBinaryData(binaryLibrary, group);
        }
        return zipper.close();
    }

    private void enrichEntriesWithBinaryData(Binaries binaryLibrary, Group group) {
        ArrayList<Entry> removeList = new ArrayList<Entry>();
        ArrayList<Entry> addList = new ArrayList<Entry>();
        List<Entry> entries = group.getEntries();
        for (Entry entry : entries) {
            EntryBuilder newEntryBuilder = new EntryBuilder(entry);
            List<Attachment> newAttachmentList = newEntryBuilder.getAttachmentList();
            newAttachmentList.clear();
            for (Attachment attachment : entry.getAttachments()) {
                byte[] attachmentData = this.getBinaryData(attachment.getRef(), binaryLibrary);
                Attachment attachmentWithData = new Attachment(attachment.getKey(), attachment.getRef(), attachmentData);
                newAttachmentList.add(attachmentWithData);
            }
            Entry entryWithAttachmentData = newEntryBuilder.build();
            removeList.add(entry);
            addList.add(entryWithAttachmentData);
        }
        group.getEntries().removeAll(removeList);
        group.getEntries().addAll(addList);
    }

    private byte[] getBinaryData(int binaryId, Binaries binaryLibrary) {
        Binary binary = binaryLibrary.getBinaryById(binaryId);
        return binary.getData();
    }
}

