/*
 * Decompiled with CFR 0.152.
 */
package de.slub.urn;

import de.slub.urn.RFC;
import de.slub.urn.RFCSupport;
import de.slub.urn.URNSyntaxError;

public abstract class NamespaceIdentifier
implements RFCSupport {
    private final String nid;

    public NamespaceIdentifier(String nid) throws URNSyntaxError {
        if (nid == null || nid.isEmpty()) {
            throw new IllegalArgumentException("Namespace identifier part cannot be null or empty");
        }
        if ("urn".equalsIgnoreCase(nid)) {
            throw URNSyntaxError.reservedIdentifier(this.supportedRFC(), nid);
        }
        if (nid.length() > 32) {
            throw URNSyntaxError.lengthError(this.supportedRFC(), nid);
        }
        String validationError = this.validateNamespaceIdentifier(nid);
        if (validationError != null) {
            throw URNSyntaxError.syntaxError(this.supportedRFC(), validationError);
        }
        this.nid = nid;
    }

    protected abstract String validateNamespaceIdentifier(String var1);

    public NamespaceIdentifier(NamespaceIdentifier instanceForCopying) {
        if (instanceForCopying == null) {
            throw new IllegalArgumentException("Namespace identifier cannot be null");
        }
        this.nid = instanceForCopying.nid;
    }

    public int hashCode() {
        return this.nid.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof NamespaceIdentifier && this.nid.equalsIgnoreCase(((NamespaceIdentifier)obj).nid);
    }

    public String toString() {
        return this.nid;
    }

    @Override
    public boolean supports(RFC rfc) {
        return this.supportedRFC().equals((Object)rfc);
    }
}

