/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.enforcer.rule;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import jdepend.framework.JDepend;
import jdepend.framework.JavaPackage;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNoCyclicPackageDependencyRule
implements EnforcerRule {
    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            String projectName = project.getName();
            File classesDir = new File((String)helper.evaluate("${project.build.outputDirectory}"));
            if (classesDir.canRead()) {
                JDepend jdepend = new JDepend();
                jdepend.addDirectory(classesDir.getAbsolutePath());
                this.addTestClassesIfRequested(helper, classesDir, jdepend);
                Collection packages = jdepend.analyze();
                if (jdepend.containsCycles()) {
                    String buffer = AbstractNoCyclicPackageDependencyRule.collectCycles(packages);
                    throw new EnforcerRuleException("Dependency cycle check found package cycles in '" + projectName + "': " + buffer);
                }
                log.info((CharSequence)("No package cycles found in '" + projectName + "'."));
            } else {
                log.warn((CharSequence)("Skipping package cycle analysis since '" + classesDir + "' does not exist."));
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Dependency cycle check is unable to evaluate expression '" + e.getLocalizedMessage() + "'.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new EnforcerRuleException("Dependency cycle check is unable to access a classes directory '" + e.getLocalizedMessage() + "'.", (Exception)e);
        }
    }

    private void addTestClassesIfRequested(EnforcerRuleHelper helper, File classesDir, JDepend jdepend) throws ExpressionEvaluationException, IOException {
        File testClassesDir;
        if (this.includeTests() && (testClassesDir = new File((String)helper.evaluate("${project.build.testOutputDirectory}"))).canRead()) {
            jdepend.addDirectory(classesDir.getAbsolutePath());
        }
    }

    protected abstract boolean includeTests();

    private static String collectCycles(Collection<JavaPackage> packages) {
        StringBuilder buffer = new StringBuilder(512);
        for (JavaPackage aPackage : packages) {
            ArrayList dependencies = new ArrayList();
            aPackage.collectCycle(dependencies);
            if (dependencies.isEmpty()) continue;
            for (JavaPackage dependency : dependencies) {
                buffer.append("->").append(dependency.getName());
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public String getCacheId() {
        return "";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule rule) {
        return false;
    }
}

