/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.enforcer.rule;

import java.util.List;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoSnapshotsInDependencyManagementRule
implements EnforcerRule {
    private boolean onlyWhenRelease = true;
    private boolean checkOnlyResolvedDependencies = false;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            List dependencies;
            List declaredDependencies;
            DependencyManagement originalDependencyManagement;
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            boolean isSnapshot = project.getArtifact().isSnapshot();
            if (this.onlyWhenRelease && isSnapshot) {
                log.info((CharSequence)(this.getCacheId() + ": Skipping since not a release."));
                return;
            }
            DependencyManagement dependencyManagement = project.getModel().getDependencyManagement();
            if (dependencyManagement == null) {
                log.debug((CharSequence)(this.getCacheId() + ": No dependency management block found."));
                return;
            }
            if (!this.checkOnlyResolvedDependencies && (originalDependencyManagement = project.getOriginalModel().getDependencyManagement()) != null && (declaredDependencies = originalDependencyManagement.getDependencies()) != null && !declaredDependencies.isEmpty()) {
                this.checkDependenciesForSnapshots(helper, log, declaredDependencies);
            }
            if ((dependencies = dependencyManagement.getDependencies()) == null || dependencies.isEmpty()) {
                log.debug((CharSequence)(this.getCacheId() + ": No dependencies in dependency management block found."));
                return;
            }
            this.checkDependenciesForSnapshots(helper, log, dependencies);
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to evaluate expression '" + e.getLocalizedMessage() + "'.", (Exception)((Object)e));
        }
    }

    private void checkDependenciesForSnapshots(EnforcerRuleHelper helper, Log log, List<Dependency> dependencies) throws EnforcerRuleException {
        StringBuilder buffer = new StringBuilder();
        for (Dependency dependency : dependencies) {
            String version = this.resolveVersion(helper, dependency);
            if (NoSnapshotsInDependencyManagementRule.isSnapshot(version)) {
                buffer.append("\n  ").append(version).append(": ").append(dependency);
                continue;
            }
            log.debug((CharSequence)("  Not a SNAPSHOT: " + dependency));
        }
        if (buffer.length() > 0) {
            throw new EnforcerRuleException("Dependency Management contains SNAPSHOTS:" + buffer.toString() + "\n Please remove all SNAPSHOT dependencies!");
        }
    }

    private String resolveVersion(EnforcerRuleHelper helper, Dependency dependency) {
        String plainVersion = dependency.getVersion();
        try {
            Object versionInstance = helper.evaluate(plainVersion);
            String version = versionInstance != null ? String.valueOf(versionInstance) : null;
            return version;
        }
        catch (ExpressionEvaluationException e) {
            return plainVersion;
        }
    }

    private static boolean isSnapshot(String version) {
        return StringUtils.isNotBlank((String)version) && version.endsWith("-SNAPSHOT");
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule cachedRule) {
        return false;
    }

    public String getCacheId() {
        return "noSnapshotsInDependencyManagement";
    }
}

