/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.softwareforge.testing.postgres.embedded.DatabaseInfo;
import de.softwareforge.testing.postgres.embedded.DatabasePreparer;
import de.softwareforge.testing.postgres.embedded.EmbeddedPostgres;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseManager
implements AutoCloseable {
    public static final Logger LOG = LoggerFactory.getLogger(DatabaseManager.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean started = new AtomicBoolean();
    private final DatabasePreparer databasePreparer;
    private final Set<EmbeddedPostgres.BuilderCustomizer> customizers;
    private final boolean multiMode;
    private volatile InstanceProvider instanceProvider = null;
    private volatile EmbeddedPostgres pg = null;

    private DatabaseManager(DatabasePreparer databasePreparer, Set<EmbeddedPostgres.BuilderCustomizer> customizers, boolean multiMode) {
        this.databasePreparer = (DatabasePreparer)Preconditions.checkNotNull((Object)databasePreparer, (Object)"databasePreparer is null");
        this.customizers = (Set)Preconditions.checkNotNull(customizers, (Object)"customizers is null");
        this.multiMode = multiMode;
    }

    public static Builder<DatabaseManager> multiDatabases() {
        return new DatabaseManagerBuilder(true);
    }

    public static Builder<DatabaseManager> singleDatabase() {
        return new DatabaseManagerBuilder(false);
    }

    public DatabaseManager start() throws IOException, SQLException {
        if (!this.started.getAndSet(true)) {
            EmbeddedPostgres.Builder builder = EmbeddedPostgres.builder();
            for (EmbeddedPostgres.BuilderCustomizer customizer : this.customizers) {
                customizer.customize(builder);
            }
            this.pg = builder.build();
            DataSource dataSourceToPrepare = this.multiMode ? this.pg.createTemplateDataSource() : this.pg.createDefaultDataSource();
            this.databasePreparer.prepare(dataSourceToPrepare);
            this.instanceProvider = this.multiMode ? new InstanceProviderPipeline() : () -> this.pg.createDefaultDatabaseInfo();
            this.instanceProvider.start();
        }
        return this;
    }

    @Override
    public void close() throws Exception {
        Preconditions.checkState((boolean)this.started.get(), (Object)"not yet started!");
        if (!this.closed.getAndSet(true)) {
            this.instanceProvider.close();
            this.pg.close();
        }
    }

    public DatabaseInfo getDatabaseInfo() throws SQLException {
        Preconditions.checkState((boolean)this.started.get(), (Object)"not yet started!");
        DatabaseInfo databaseInfo = this.instanceProvider.get();
        if (databaseInfo.exception().isEmpty()) {
            return databaseInfo;
        }
        throw databaseInfo.exception().get();
    }

    public EmbeddedPostgres getEmbeddedPostgres() {
        Preconditions.checkState((boolean)this.started.get(), (Object)"not yet started!");
        return this.pg;
    }

    private static void createDatabase(DataSource dataSource, String databaseName, String user) throws SQLException {
        try (Connection c = dataSource.getConnection();
             Statement stmt = c.createStatement();){
            stmt.executeUpdate(String.format("CREATE DATABASE %s OWNER %s ENCODING = 'utf8'", databaseName, user));
        }
    }

    public static class DatabaseManagerBuilder
    extends Builder<DatabaseManager> {
        public DatabaseManagerBuilder(boolean multiMode) {
            super(multiMode);
        }

        @Override
        public DatabaseManager build() {
            return new DatabaseManager(this.databasePreparer, (Set<EmbeddedPostgres.BuilderCustomizer>)this.customizers.build(), this.multiMode);
        }
    }

    public static abstract class Builder<T> {
        protected DatabasePreparer databasePreparer = DatabasePreparer.NOOP_PREPARER;
        protected ImmutableSet.Builder<EmbeddedPostgres.BuilderCustomizer> customizers = ImmutableSet.builder();
        protected final boolean multiMode;

        protected Builder(boolean multiMode) {
            this.multiMode = multiMode;
        }

        public Builder<T> withPreparer(DatabasePreparer databasePreparer) {
            this.databasePreparer = (DatabasePreparer)Preconditions.checkNotNull((Object)databasePreparer, (Object)"databasePreparer is null");
            return this;
        }

        public Builder<T> withCustomizer(EmbeddedPostgres.BuilderCustomizer customizer) {
            this.customizers.add((Object)((EmbeddedPostgres.BuilderCustomizer)Preconditions.checkNotNull((Object)customizer, (Object)"customizer is null")));
            return this;
        }

        public abstract T build();
    }

    private final class InstanceProviderPipeline
    implements InstanceProvider,
    Runnable {
        private final ExecutorService executor;
        private final SynchronousQueue<DatabaseInfo> nextDatabase = new SynchronousQueue();
        private final AtomicBoolean closed = new AtomicBoolean();

        public InstanceProviderPipeline() {
            this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("instance-creator-" + DatabaseManager.this.pg.instanceId() + "-%d").build());
        }

        @Override
        public void start() {
            this.executor.submit(this);
        }

        @Override
        public void close() {
            if (!this.closed.getAndSet(true)) {
                this.executor.shutdownNow();
            }
        }

        @Override
        public void run() {
            while (!this.closed.get()) {
                try {
                    String newDbName = RandomStringUtils.randomAlphabetic((int)12).toLowerCase(Locale.ROOT);
                    try {
                        DatabaseManager.createDatabase(DatabaseManager.this.pg.createDefaultDataSource(), newDbName, "postgres");
                        this.nextDatabase.put(DatabaseInfo.builder().dbName(newDbName).port(DatabaseManager.this.pg.getPort()).properties(DatabaseManager.this.pg.getConnectionProperties()).build());
                    }
                    catch (SQLException e) {
                        if (e.getSQLState().equals("57P01")) continue;
                        LOG.warn("Caught SQL Exception (" + e.getSQLState() + "):", (Throwable)e);
                        this.nextDatabase.put(DatabaseInfo.forException(e));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (Throwable t) {
                    LOG.warn("Caught Throwable in loop:", t);
                }
            }
        }

        @Override
        public DatabaseInfo get() {
            try {
                return this.nextDatabase.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }
    }

    private static interface InstanceProvider
    extends Supplier<DatabaseInfo>,
    AutoCloseable {
        default public void start() {
        }

        @Override
        default public void close() {
        }

        @Override
        public DatabaseInfo get();
    }
}

