/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channel;
import java.nio.channels.CompletionHandler;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Comparator;
import java.util.concurrent.Phaser;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tukaani.xz.XZInputStream;

final class EmbeddedUtil {
    static final Logger LOG = LoggerFactory.getLogger(EmbeddedUtil.class);

    private EmbeddedUtil() {
        throw new AssertionError((Object)"EmbeddedUtil can not be instantiated");
    }

    static File getWorkingDirectory() {
        return new File(SystemUtils.getJavaIoTmpDir(), "embedded-pg");
    }

    static String getFileBaseName(String fileName) {
        if (fileName == null) {
            return null;
        }
        EmbeddedUtil.failIfNullBytePresent(fileName);
        int index = EmbeddedUtil.indexOfLastSeparator(fileName);
        return fileName.substring(index + 1);
    }

    private static void failIfNullBytePresent(String path) {
        int len = path.length();
        for (int i = 0; i < len; ++i) {
            Preconditions.checkArgument((path.charAt(i) != '\u0000' ? 1 : 0) != 0, (Object)"Null byte present in file/path name.");
        }
    }

    private static int indexOfLastSeparator(String fileName) {
        if (fileName == null) {
            return -1;
        }
        int lastUnixPos = fileName.lastIndexOf(47);
        int lastWindowsPos = fileName.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    static void mkdirs(File dir) {
        if (!(dir.mkdirs() || dir.isDirectory() && dir.exists())) {
            throw new IllegalStateException("could not create " + dir);
        }
    }

    static void rmdirs(File dir) throws IOException {
        try (Stream<Path> walk = Files.walk(dir.toPath(), new FileVisitOption[0]);){
            walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
    }

    static String formatDuration(Duration duration) {
        return DurationFormatUtils.formatDuration((long)duration.toMillis(), (String)"s' seconds 'S' ms'");
    }

    static int allocatePort() throws IOException {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            while (!socket.isBound()) {
                Thread.sleep(50L);
            }
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Thread interrupted!", e);
            }
        }
        socket.close();
        return n;
    }

    static String getOS() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "windows";
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            return "darwin";
        }
        if (SystemUtils.IS_OS_LINUX) {
            return "linux";
        }
        throw new UnsupportedOperationException("Unknown OS " + SystemUtils.OS_NAME);
    }

    static String getArchitecture() {
        return "amd64".equals(SystemUtils.OS_ARCH) ? "x86_64" : SystemUtils.OS_ARCH;
    }

    static void extractTxz(InputStream stream, String targetDir) throws IOException {
        try (XZInputStream xzIn = new XZInputStream(stream);
             TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)xzIn);){
            TarArchiveEntry entry;
            final Phaser phaser = new Phaser(1);
            while ((entry = tarIn.getNextTarEntry()) != null) {
                String individualFile = entry.getName();
                final File fsObject = new File(targetDir, individualFile);
                Path fsPath = fsObject.toPath();
                if (Files.exists(fsPath, LinkOption.NOFOLLOW_LINKS) && !Files.isDirectory(fsPath, LinkOption.NOFOLLOW_LINKS)) {
                    Files.delete(fsPath);
                    LOG.debug("Deleting existing entry %s", (Object)fsPath);
                }
                if (entry.isSymbolicLink() || entry.isLink()) {
                    Path target = FileSystems.getDefault().getPath(entry.getLinkName(), new String[0]);
                    Files.createSymbolicLink(fsPath, target, new FileAttribute[0]);
                } else if (entry.isFile()) {
                    byte[] content = new byte[(int)entry.getSize()];
                    int read = tarIn.read(content, 0, content.length);
                    Preconditions.checkState((read != -1 ? 1 : 0) != 0, (String)"could not read %s", (Object)individualFile);
                    EmbeddedUtil.mkdirs(fsObject.getParentFile());
                    AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(fsPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    phaser.register();
                    fileChannel.write(buffer, 0L, fileChannel, new CompletionHandler<Integer, Channel>(){

                        @Override
                        public void completed(Integer written, Channel channel) {
                            this.closeChannel(channel);
                        }

                        @Override
                        public void failed(Throwable error, Channel channel) {
                            LOG.error("could not write file " + fsObject.getAbsolutePath(), error);
                            this.closeChannel(channel);
                        }

                        private void closeChannel(Channel channel) {
                            try {
                                channel.close();
                            }
                            catch (IOException e) {
                                LOG.error("While closing channel:", (Throwable)e);
                            }
                            finally {
                                phaser.arriveAndDeregister();
                            }
                        }
                    });
                } else if (entry.isDirectory()) {
                    EmbeddedUtil.mkdirs(fsObject);
                } else {
                    throw new UnsupportedOperationException(String.format("unsupported entry found: %s", individualFile));
                }
                if (!individualFile.startsWith("bin/") && !individualFile.startsWith("./bin/")) continue;
                fsObject.setExecutable(true, false);
            }
            phaser.arriveAndAwaitAdvance();
        }
    }
}

