/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import de.softwareforge.testing.postgres.embedded.DatabasePreparer;
import java.sql.SQLException;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;

public class FlywayPreparer
implements DatabasePreparer {
    private final ImmutableList.Builder<Consumer<FluentConfiguration>> customizers = ImmutableList.builder();

    public static FlywayPreparer forClasspathLocation(String ... locations) {
        FlywayPreparer preparer = new FlywayPreparer();
        preparer.customize(c -> c.locations(locations));
        return preparer;
    }

    protected FlywayPreparer() {
    }

    public FlywayPreparer customize(Consumer<FluentConfiguration> customizer) {
        Preconditions.checkNotNull(customizer, (Object)"customizer is null");
        this.customizers.add(customizer);
        return this;
    }

    @Override
    public void prepare(DataSource ds) throws SQLException {
        FluentConfiguration config = Flyway.configure();
        this.customizers.build().forEach(c -> c.accept(config));
        config.dataSource(ds);
        config.load().migrate();
    }
}

