/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import de.softwareforge.testing.postgres.embedded.EmbeddedUtil;
import de.softwareforge.testing.postgres.embedded.PgArchiveResolver;
import de.softwareforge.testing.postgres.embedded.PgDirectoryResolver;
import de.softwareforge.testing.postgres.embedded.ZonkyIOPostgresArchiveResolver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileLock;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UncompressBundleDirectoryResolver
implements PgDirectoryResolver {
    private static final Logger LOG = LoggerFactory.getLogger(UncompressBundleDirectoryResolver.class);
    private static final String INSTALL_DIRECTORY_PREFIX = "PG-";
    private static final Supplier<UncompressBundleDirectoryResolver> DEFAULT_INSTANCE_HOLDER = Suppliers.memoize(UncompressBundleDirectoryResolver::new);
    private static final Map<PgArchiveResolver, File> KNOWN_INSTALLATIONS = new ConcurrentHashMap<PgArchiveResolver, File>();
    private final Lock prepareBinariesLock = new ReentrantLock();
    private final PgArchiveResolver pgArchiveResolver;

    public static synchronized UncompressBundleDirectoryResolver getDefault() {
        return DEFAULT_INSTANCE_HOLDER.get();
    }

    private UncompressBundleDirectoryResolver() {
        this(ZonkyIOPostgresArchiveResolver.INSTANCE);
    }

    public UncompressBundleDirectoryResolver(PgArchiveResolver pgArchiveResolver) {
        this.pgArchiveResolver = (PgArchiveResolver)Preconditions.checkNotNull((Object)pgArchiveResolver, (Object)"pgArchiveResolver is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File getDirectory(File installationDirectory) {
        this.prepareBinariesLock.lock();
        try {
            File pgDir;
            block41: {
                File pgDirExists;
                String pgDigest;
                File pgDir2;
                if (KNOWN_INSTALLATIONS.containsKey(this.pgArchiveResolver) && (pgDir2 = KNOWN_INSTALLATIONS.get(this.pgArchiveResolver)).exists()) {
                    File file = pgDir2;
                    return file;
                }
                String system = EmbeddedUtil.getOS();
                String machineHardware = EmbeddedUtil.getArchitecture();
                LOG.debug(String.format("Detected a %s %s system", system, machineHardware));
                try (InputStream pgArchive = this.pgArchiveResolver.locatePgArchive(system, machineHardware);){
                    Preconditions.checkState((pgArchive != null ? 1 : 0) != 0, (Object)("No Postgres archive found for " + system + " / " + machineHardware));
                    try (DigestInputStream pgArchiveData = new DigestInputStream(pgArchive, MessageDigest.getInstance("MD5"));){
                        ByteStreams.exhaust((InputStream)pgArchiveData);
                        pgDigest = BaseEncoding.base16().encode(pgArchiveData.getMessageDigest().digest());
                    }
                }
                if (!installationDirectory.setWritable(true, false)) {
                    LOG.warn(String.format("Could not make install directory %s writable!", installationDirectory));
                }
                pgDir = new File(installationDirectory, INSTALL_DIRECTORY_PREFIX + pgDigest);
                EmbeddedUtil.mkdirs(pgDir);
                File unpackLockFile = new File(pgDir, "epg-lock");
                if (pgDir.getName().startsWith(INSTALL_DIRECTORY_PREFIX) && !(pgDirExists = new File(pgDir, ".exists")).exists()) {
                    try {
                        try (FileOutputStream lockStream = new FileOutputStream(unpackLockFile);
                             FileLock unpackLock = lockStream.getChannel().tryLock();){
                            if (unpackLock != null) {
                                try {
                                    Preconditions.checkState((!pgDirExists.exists() ? 1 : 0) != 0, (Object)("unpack lock acquired but .exists file is present " + pgDirExists));
                                    LOG.info("extracting archive...");
                                    InputStream x = this.pgArchiveResolver.locatePgArchive(system, machineHardware);
                                    EmbeddedUtil.extractTxz(x, pgDir.getPath());
                                    Preconditions.checkState((boolean)pgDirExists.createNewFile(), (Object)("couldn't make .exists file " + pgDirExists));
                                }
                                catch (Exception e) {
                                    LOG.error("while unpacking archive:", (Throwable)e);
                                }
                            } else {
                                int maxAttempts = 60;
                                while (!pgDirExists.exists() && --maxAttempts > 0) {
                                    Thread.sleep(1000L);
                                }
                                Preconditions.checkState((boolean)pgDirExists.exists(), (Object)"Waited 60 seconds for postgres to be unpacked but it never finished!");
                            }
                        }
                        if (!unpackLockFile.exists() || unpackLockFile.delete()) break block41;
                    }
                    catch (Throwable throwable) {
                        if (!unpackLockFile.exists()) throw throwable;
                        if (unpackLockFile.delete()) throw throwable;
                        LOG.error(String.format("could not remove lock file %s", unpackLockFile.getAbsolutePath()));
                        throw throwable;
                    }
                    LOG.error(String.format("could not remove lock file %s", unpackLockFile.getAbsolutePath()));
                }
            }
            KNOWN_INSTALLATIONS.putIfAbsent(this.pgArchiveResolver, pgDir);
            LOG.debug(String.format("Unpacked archive at %s", pgDir));
            File file = pgDir;
            return file;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ExceptionInInitializerError(e);
        }
        finally {
            this.prepareBinariesLock.unlock();
        }
    }
}

