/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.junit5;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import de.softwareforge.testing.postgres.embedded.DatabaseInfo;
import de.softwareforge.testing.postgres.embedded.DatabaseManager;
import de.softwareforge.testing.postgres.embedded.EmbeddedPostgres;
import java.io.IOException;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmbeddedPgExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedPgExtension.class);
    private final DatabaseManager.Builder<DatabaseManager> databaseManagerBuilder;
    private volatile boolean perTestMode = true;
    private volatile DatabaseManager databaseManager = null;

    private EmbeddedPgExtension(DatabaseManager.Builder<DatabaseManager> databaseManagerBuilder) {
        this.databaseManagerBuilder = databaseManagerBuilder;
    }

    public static EmbeddedPgExtensionBuilder multiDatabase() {
        return new EmbeddedPgExtensionBuilder(true);
    }

    public static EmbeddedPgExtensionBuilder singleDatabase() {
        return new EmbeddedPgExtensionBuilder(false);
    }

    public DataSource createDataSource() throws SQLException {
        return this.createDatabaseInfo().asDataSource();
    }

    @VisibleForTesting
    EmbeddedPostgres getEmbeddedPostgres() {
        return this.databaseManager.getEmbeddedPostgres();
    }

    public DatabaseInfo createDatabaseInfo() throws SQLException {
        Preconditions.checkState((this.databaseManager != null ? 1 : 0) != 0, (Object)"no before method has been called!");
        DatabaseInfo databaseInfo = this.databaseManager.getDatabaseInfo();
        if (databaseInfo.exception().isEmpty()) {
            LOG.info("Connection to {}", (Object)databaseInfo.asJdbcUrl());
        }
        return databaseInfo;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.perTestMode = false;
        this.startDbProvider();
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        Preconditions.checkNotNull((Object)extensionContext, (Object)"extensionContext is null");
        if (!this.perTestMode) {
            this.stopDbProvider();
            this.perTestMode = true;
        }
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        Preconditions.checkNotNull((Object)extensionContext, (Object)"extensionContext is null");
        if (this.perTestMode) {
            this.startDbProvider();
        }
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        Preconditions.checkNotNull((Object)extensionContext, (Object)"extensionContext is null");
        if (this.perTestMode) {
            this.stopDbProvider();
        }
    }

    private void startDbProvider() throws SQLException, IOException {
        this.databaseManager = this.databaseManagerBuilder.build();
        this.databaseManager.start();
    }

    private void stopDbProvider() throws Exception {
        DatabaseManager provider = this.databaseManager;
        this.databaseManager = null;
        if (provider != null) {
            provider.close();
        }
    }

    static class EmbeddedPgExtensionBuilder
    extends DatabaseManager.Builder<EmbeddedPgExtension> {
        private EmbeddedPgExtensionBuilder(boolean multiMode) {
            super(multiMode);
        }

        @Override
        public EmbeddedPgExtension build() {
            DatabaseManager.Builder<DatabaseManager> databaseManagerBuilder = new DatabaseManager.DatabaseManagerBuilder(this.multiMode).withPreparer(this.databasePreparer);
            this.customizers.build().forEach(databaseManagerBuilder::withCustomizer);
            return new EmbeddedPgExtension(databaseManagerBuilder);
        }
    }
}

