/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.org.tukaani.xz;

import de.softwareforge.testing.org.tukaani.xz.$ArrayCache;
import de.softwareforge.testing.org.tukaani.xz.$FinishableOutputStream;
import de.softwareforge.testing.org.tukaani.xz.$LZMA2Options;
import de.softwareforge.testing.org.tukaani.xz.$XZIOException;
import de.softwareforge.testing.org.tukaani.xz.lz.$LZEncoder;
import de.softwareforge.testing.org.tukaani.xz.lzma.$LZMAEncoder;
import de.softwareforge.testing.org.tukaani.xz.rangecoder.$RangeEncoderToBuffer;
import java.io.IOException;

class $LZMA2OutputStream
extends $FinishableOutputStream {
    static final int COMPRESSED_SIZE_MAX = 65536;
    private final $ArrayCache arrayCache;
    private $FinishableOutputStream out;
    private $LZEncoder lz;
    private $RangeEncoderToBuffer rc;
    private $LZMAEncoder lzma;
    private final int props;
    private boolean dictResetNeeded = true;
    private boolean stateResetNeeded = true;
    private boolean propsNeeded = true;
    private int pendingSize = 0;
    private boolean finished = false;
    private IOException exception = null;
    private final byte[] chunkHeader = new byte[6];
    private final byte[] tempBuf = new byte[1];

    private static int getExtraSizeBefore(int n) {
        return 65536 > n ? 65536 - n : 0;
    }

    static int getMemoryUsage($LZMA2Options $LZMA2Options) {
        int n = $LZMA2Options.getDictSize();
        int n2 = $LZMA2OutputStream.getExtraSizeBefore(n);
        return 70 + $LZMAEncoder.getMemoryUsage($LZMA2Options.getMode(), n, n2, $LZMA2Options.getMatchFinder());
    }

    $LZMA2OutputStream($FinishableOutputStream $FinishableOutputStream, $LZMA2Options $LZMA2Options, $ArrayCache $ArrayCache) {
        if ($FinishableOutputStream == null) {
            throw new NullPointerException();
        }
        this.arrayCache = $ArrayCache;
        this.out = $FinishableOutputStream;
        this.rc = new $RangeEncoderToBuffer(65536, $ArrayCache);
        int n = $LZMA2Options.getDictSize();
        int n2 = $LZMA2OutputStream.getExtraSizeBefore(n);
        this.lzma = $LZMAEncoder.getInstance(this.rc, $LZMA2Options.getLc(), $LZMA2Options.getLp(), $LZMA2Options.getPb(), $LZMA2Options.getMode(), n, n2, $LZMA2Options.getNiceLen(), $LZMA2Options.getMatchFinder(), $LZMA2Options.getDepthLimit(), this.arrayCache);
        this.lz = this.lzma.getLZEncoder();
        byte[] byArray = $LZMA2Options.getPresetDict();
        if (byArray != null && byArray.length > 0) {
            this.lz.setPresetDict(n, byArray);
            this.dictResetNeeded = false;
        }
        this.props = ($LZMA2Options.getPb() * 5 + $LZMA2Options.getLp()) * 9 + $LZMA2Options.getLc();
    }

    @Override
    public void write(int n) throws IOException {
        this.tempBuf[0] = (byte)n;
        this.write(this.tempBuf, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new $XZIOException("Stream finished or closed");
        }
        try {
            while (n2 > 0) {
                int n3 = this.lz.fillWindow(byArray, n, n2);
                n += n3;
                n2 -= n3;
                this.pendingSize += n3;
                if (!this.lzma.encodeForLZMA2()) continue;
                this.writeChunk();
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    private void writeChunk() throws IOException {
        int n = this.rc.finish();
        int n2 = this.lzma.getUncompressedSize();
        assert (n > 0) : n;
        assert (n2 > 0) : n2;
        if (n + 2 < n2) {
            this.writeLZMA(n2, n);
        } else {
            this.lzma.reset();
            n2 = this.lzma.getUncompressedSize();
            assert (n2 > 0) : n2;
            this.writeUncompressed(n2);
        }
        this.pendingSize -= n2;
        this.lzma.resetUncompressedSize();
        this.rc.reset();
    }

    private void writeLZMA(int n, int n2) throws IOException {
        int n3 = this.propsNeeded ? (this.dictResetNeeded ? 224 : 192) : (this.stateResetNeeded ? 160 : 128);
        this.chunkHeader[0] = (byte)(n3 |= n - 1 >>> 16);
        this.chunkHeader[1] = (byte)(n - 1 >>> 8);
        this.chunkHeader[2] = (byte)(n - 1);
        this.chunkHeader[3] = (byte)(n2 - 1 >>> 8);
        this.chunkHeader[4] = (byte)(n2 - 1);
        if (this.propsNeeded) {
            this.chunkHeader[5] = (byte)this.props;
            this.out.write(this.chunkHeader, 0, 6);
        } else {
            this.out.write(this.chunkHeader, 0, 5);
        }
        this.rc.write(this.out);
        this.propsNeeded = false;
        this.stateResetNeeded = false;
        this.dictResetNeeded = false;
    }

    private void writeUncompressed(int n) throws IOException {
        while (n > 0) {
            int n2 = Math.min(n, 65536);
            this.chunkHeader[0] = (byte)(this.dictResetNeeded ? 1 : 2);
            this.chunkHeader[1] = (byte)(n2 - 1 >>> 8);
            this.chunkHeader[2] = (byte)(n2 - 1);
            this.out.write(this.chunkHeader, 0, 3);
            this.lz.copyUncompressed(this.out, n, n2);
            n -= n2;
            this.dictResetNeeded = false;
        }
        this.stateResetNeeded = true;
    }

    private void writeEndMarker() throws IOException {
        assert (!this.finished);
        if (this.exception != null) {
            throw this.exception;
        }
        this.lz.setFinishing();
        try {
            while (this.pendingSize > 0) {
                this.lzma.encodeForLZMA2();
                this.writeChunk();
            }
            this.out.write(0);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
        this.finished = true;
        this.lzma.putArraysToCache(this.arrayCache);
        this.lzma = null;
        this.lz = null;
        this.rc.putArraysToCache(this.arrayCache);
        this.rc = null;
    }

    @Override
    public void flush() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new $XZIOException("Stream finished or closed");
        }
        try {
            this.lz.setFlushing();
            while (this.pendingSize > 0) {
                this.lzma.encodeForLZMA2();
                this.writeChunk();
            }
            this.out.flush();
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    @Override
    public void finish() throws IOException {
        if (!this.finished) {
            this.writeEndMarker();
            try {
                this.out.finish();
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            block7: {
                if (!this.finished) {
                    try {
                        this.writeEndMarker();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    if (this.exception != null) break block7;
                    this.exception = iOException;
                }
            }
            this.out = null;
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }
}

