/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.org.tukaani.xz;

import de.softwareforge.testing.org.tukaani.xz.$ArrayCache;
import de.softwareforge.testing.org.tukaani.xz.$FinishableOutputStream;
import de.softwareforge.testing.org.tukaani.xz.$LZMA2Options;
import de.softwareforge.testing.org.tukaani.xz.$UnsupportedOptionsException;
import de.softwareforge.testing.org.tukaani.xz.$XZIOException;
import de.softwareforge.testing.org.tukaani.xz.lz.$LZEncoder;
import de.softwareforge.testing.org.tukaani.xz.lzma.$LZMAEncoder;
import de.softwareforge.testing.org.tukaani.xz.rangecoder.$RangeEncoderToStream;
import java.io.IOException;
import java.io.OutputStream;

public class $LZMAOutputStream
extends $FinishableOutputStream {
    private OutputStream out;
    private final $ArrayCache arrayCache;
    private $LZEncoder lz;
    private final $RangeEncoderToStream rc;
    private $LZMAEncoder lzma;
    private final int props;
    private final boolean useEndMarker;
    private final long expectedUncompressedSize;
    private long currentUncompressedSize = 0L;
    private boolean finished = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    private $LZMAOutputStream(OutputStream outputStream, $LZMA2Options $LZMA2Options, boolean bl, boolean bl2, long l, $ArrayCache $ArrayCache) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (l < -1L) {
            throw new IllegalArgumentException("Invalid expected input size (less than -1)");
        }
        this.useEndMarker = bl2;
        this.expectedUncompressedSize = l;
        this.arrayCache = $ArrayCache;
        this.out = outputStream;
        this.rc = new $RangeEncoderToStream(outputStream);
        int n = $LZMA2Options.getDictSize();
        this.lzma = $LZMAEncoder.getInstance(this.rc, $LZMA2Options.getLc(), $LZMA2Options.getLp(), $LZMA2Options.getPb(), $LZMA2Options.getMode(), n, 0, $LZMA2Options.getNiceLen(), $LZMA2Options.getMatchFinder(), $LZMA2Options.getDepthLimit(), $ArrayCache);
        this.lz = this.lzma.getLZEncoder();
        byte[] byArray = $LZMA2Options.getPresetDict();
        if (byArray != null && byArray.length > 0) {
            if (bl) {
                throw new $UnsupportedOptionsException("Preset dictionary cannot be used in .lzma files (try a raw LZMA stream instead)");
            }
            this.lz.setPresetDict(n, byArray);
        }
        this.props = ($LZMA2Options.getPb() * 5 + $LZMA2Options.getLp()) * 9 + $LZMA2Options.getLc();
        if (bl) {
            int n2;
            outputStream.write(this.props);
            for (n2 = 0; n2 < 4; ++n2) {
                outputStream.write(n & 0xFF);
                n >>>= 8;
            }
            for (n2 = 0; n2 < 8; ++n2) {
                outputStream.write((int)(l >>> 8 * n2) & 0xFF);
            }
        }
    }

    public $LZMAOutputStream(OutputStream outputStream, $LZMA2Options $LZMA2Options, long l) throws IOException {
        this(outputStream, $LZMA2Options, l, $ArrayCache.getDefaultCache());
    }

    public $LZMAOutputStream(OutputStream outputStream, $LZMA2Options $LZMA2Options, long l, $ArrayCache $ArrayCache) throws IOException {
        this(outputStream, $LZMA2Options, true, l == -1L, l, $ArrayCache);
    }

    public $LZMAOutputStream(OutputStream outputStream, $LZMA2Options $LZMA2Options, boolean bl) throws IOException {
        this(outputStream, $LZMA2Options, bl, $ArrayCache.getDefaultCache());
    }

    public $LZMAOutputStream(OutputStream outputStream, $LZMA2Options $LZMA2Options, boolean bl, $ArrayCache $ArrayCache) throws IOException {
        this(outputStream, $LZMA2Options, false, bl, -1L, $ArrayCache);
    }

    public int getProps() {
        return this.props;
    }

    public long getUncompressedSize() {
        return this.currentUncompressedSize;
    }

    @Override
    public void write(int n) throws IOException {
        this.tempBuf[0] = (byte)n;
        this.write(this.tempBuf, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new $XZIOException("Stream finished or closed");
        }
        if (this.expectedUncompressedSize != -1L && this.expectedUncompressedSize - this.currentUncompressedSize < (long)n2) {
            throw new $XZIOException("Expected uncompressed input size (" + this.expectedUncompressedSize + " bytes) was exceeded");
        }
        this.currentUncompressedSize += (long)n2;
        try {
            while (n2 > 0) {
                int n3 = this.lz.fillWindow(byArray, n, n2);
                n += n3;
                n2 -= n3;
                this.lzma.encodeForLZMA1();
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    @Override
    public void flush() throws IOException {
        throw new $XZIOException("LZMAOutputStream does not support flushing");
    }

    @Override
    public void finish() throws IOException {
        if (!this.finished) {
            if (this.exception != null) {
                throw this.exception;
            }
            try {
                if (this.expectedUncompressedSize != -1L && this.expectedUncompressedSize != this.currentUncompressedSize) {
                    throw new $XZIOException("Expected uncompressed size (" + this.expectedUncompressedSize + ") doesn't equal the number of bytes written to the stream (" + this.currentUncompressedSize + ")");
                }
                this.lz.setFinishing();
                this.lzma.encodeForLZMA1();
                if (this.useEndMarker) {
                    this.lzma.encodeLZMA1EndMarker();
                }
                this.rc.finish();
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
            this.finished = true;
            this.lzma.putArraysToCache(this.arrayCache);
            this.lzma = null;
            this.lz = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            block6: {
                try {
                    this.finish();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    if (this.exception != null) break block6;
                    this.exception = iOException;
                }
            }
            this.out = null;
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }
}

