/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.org.tukaani.xz;

import de.softwareforge.testing.org.tukaani.xz.$ArrayCache;
import de.softwareforge.testing.org.tukaani.xz.$BlockInputStream;
import de.softwareforge.testing.org.tukaani.xz.$CorruptedInputException;
import de.softwareforge.testing.org.tukaani.xz.$IndexIndicatorException;
import de.softwareforge.testing.org.tukaani.xz.$MemoryLimitException;
import de.softwareforge.testing.org.tukaani.xz.$SeekableInputStream;
import de.softwareforge.testing.org.tukaani.xz.$UnsupportedOptionsException;
import de.softwareforge.testing.org.tukaani.xz.$XZ;
import de.softwareforge.testing.org.tukaani.xz.$XZFormatException;
import de.softwareforge.testing.org.tukaani.xz.$XZIOException;
import de.softwareforge.testing.org.tukaani.xz.check.$Check;
import de.softwareforge.testing.org.tukaani.xz.common.$DecoderUtil;
import de.softwareforge.testing.org.tukaani.xz.common.$StreamFlags;
import de.softwareforge.testing.org.tukaani.xz.index.$BlockInfo;
import de.softwareforge.testing.org.tukaani.xz.index.$IndexDecoder;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class $SeekableXZInputStream
extends $SeekableInputStream {
    private final $ArrayCache arrayCache;
    private $SeekableInputStream in;
    private final int memoryLimit;
    private int indexMemoryUsage = 0;
    private final ArrayList<$IndexDecoder> streams = new ArrayList();
    private int checkTypes = 0;
    private long uncompressedSize = 0L;
    private long largestBlockSize = 0L;
    private int blockCount = 0;
    private final $BlockInfo curBlockInfo;
    private final $BlockInfo queriedBlockInfo;
    private $Check check;
    private final boolean verifyCheck;
    private $BlockInputStream blockDecoder = null;
    private long curPos = 0L;
    private long seekPos;
    private boolean seekNeeded = false;
    private boolean endReached = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    public $SeekableXZInputStream($SeekableInputStream $SeekableInputStream) throws IOException {
        this($SeekableInputStream, -1);
    }

    public $SeekableXZInputStream($SeekableInputStream $SeekableInputStream, $ArrayCache $ArrayCache) throws IOException {
        this($SeekableInputStream, -1, $ArrayCache);
    }

    public $SeekableXZInputStream($SeekableInputStream $SeekableInputStream, int n) throws IOException {
        this($SeekableInputStream, n, true);
    }

    public $SeekableXZInputStream($SeekableInputStream $SeekableInputStream, int n, $ArrayCache $ArrayCache) throws IOException {
        this($SeekableInputStream, n, true, $ArrayCache);
    }

    public $SeekableXZInputStream($SeekableInputStream $SeekableInputStream, int n, boolean bl) throws IOException {
        this($SeekableInputStream, n, bl, $ArrayCache.getDefaultCache());
    }

    public $SeekableXZInputStream($SeekableInputStream $SeekableInputStream, int n, boolean bl, $ArrayCache $ArrayCache) throws IOException {
        Object object;
        this.arrayCache = $ArrayCache;
        this.verifyCheck = bl;
        this.in = $SeekableInputStream;
        DataInputStream dataInputStream = new DataInputStream($SeekableInputStream);
        $SeekableInputStream.seek(0L);
        byte[] byArray = new byte[$XZ.HEADER_MAGIC.length];
        dataInputStream.readFully(byArray);
        if (!Arrays.equals(byArray, $XZ.HEADER_MAGIC)) {
            throw new $XZFormatException();
        }
        long l = $SeekableInputStream.length();
        if ((l & 3L) != 0L) {
            throw new $CorruptedInputException("XZ file size is not a multiple of 4 bytes");
        }
        byte[] byArray2 = new byte[12];
        long l2 = 0L;
        while (l > 0L) {
            long l3;
            $IndexDecoder $IndexDecoder;
            if (l < 12L) {
                throw new $CorruptedInputException();
            }
            $SeekableInputStream.seek(l - 12L);
            dataInputStream.readFully(byArray2);
            if (byArray2[8] == 0 && byArray2[9] == 0 && byArray2[10] == 0 && byArray2[11] == 0) {
                l2 += 4L;
                l -= 4L;
                continue;
            }
            object = $DecoderUtil.decodeStreamFooter(byArray2);
            if ((($StreamFlags)object).backwardSize >= (l -= 12L)) {
                throw new $CorruptedInputException("Backward Size in XZ Stream Footer is too big");
            }
            this.check = $Check.getInstance((($StreamFlags)object).checkType);
            this.checkTypes |= 1 << (($StreamFlags)object).checkType;
            $SeekableInputStream.seek(l - (($StreamFlags)object).backwardSize);
            try {
                $IndexDecoder = new $IndexDecoder($SeekableInputStream, ($StreamFlags)object, l2, n);
            }
            catch ($MemoryLimitException $MemoryLimitException) {
                assert (n >= 0);
                throw new $MemoryLimitException($MemoryLimitException.getMemoryNeeded() + this.indexMemoryUsage, n + this.indexMemoryUsage);
            }
            this.indexMemoryUsage += $IndexDecoder.getMemoryUsage();
            if (n >= 0) assert ((n -= $IndexDecoder.getMemoryUsage()) >= 0);
            if (this.largestBlockSize < $IndexDecoder.getLargestBlockSize()) {
                this.largestBlockSize = $IndexDecoder.getLargestBlockSize();
            }
            if (l < (l3 = $IndexDecoder.getStreamSize() - 12L)) {
                throw new $CorruptedInputException("XZ Index indicates too big compressed size for the XZ Stream");
            }
            $SeekableInputStream.seek(l -= l3);
            dataInputStream.readFully(byArray2);
            $StreamFlags $StreamFlags = $DecoderUtil.decodeStreamHeader(byArray2);
            if (!$DecoderUtil.areStreamFlagsEqual($StreamFlags, ($StreamFlags)object)) {
                throw new $CorruptedInputException("XZ Stream Footer does not match Stream Header");
            }
            this.uncompressedSize += $IndexDecoder.getUncompressedSize();
            if (this.uncompressedSize < 0L) {
                throw new $UnsupportedOptionsException("XZ file is too big");
            }
            this.blockCount += $IndexDecoder.getRecordCount();
            if (this.blockCount < 0) {
                throw new $UnsupportedOptionsException("XZ file has over 2147483647 Blocks");
            }
            this.streams.add($IndexDecoder);
            l2 = 0L;
        }
        assert (l == 0L);
        this.memoryLimit = n;
        object = this.streams.get(this.streams.size() - 1);
        for (int i = this.streams.size() - 2; i >= 0; --i) {
            $IndexDecoder $IndexDecoder = this.streams.get(i);
            $IndexDecoder.setOffsets(($IndexDecoder)object);
            object = $IndexDecoder;
        }
        $IndexDecoder $IndexDecoder = this.streams.get(this.streams.size() - 1);
        this.curBlockInfo = new $BlockInfo($IndexDecoder);
        this.queriedBlockInfo = new $BlockInfo($IndexDecoder);
    }

    public int getCheckTypes() {
        return this.checkTypes;
    }

    public int getIndexMemoryUsage() {
        return this.indexMemoryUsage;
    }

    public long getLargestBlockSize() {
        return this.largestBlockSize;
    }

    public int getStreamCount() {
        return this.streams.size();
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public long getBlockPos(int n) {
        this.locateBlockByNumber(this.queriedBlockInfo, n);
        return this.queriedBlockInfo.uncompressedOffset;
    }

    public long getBlockSize(int n) {
        this.locateBlockByNumber(this.queriedBlockInfo, n);
        return this.queriedBlockInfo.uncompressedSize;
    }

    public long getBlockCompPos(int n) {
        this.locateBlockByNumber(this.queriedBlockInfo, n);
        return this.queriedBlockInfo.compressedOffset;
    }

    public long getBlockCompSize(int n) {
        this.locateBlockByNumber(this.queriedBlockInfo, n);
        return this.queriedBlockInfo.unpaddedSize + 3L & 0xFFFFFFFFFFFFFFFCL;
    }

    public int getBlockCheckType(int n) {
        this.locateBlockByNumber(this.queriedBlockInfo, n);
        return this.queriedBlockInfo.getCheckType();
    }

    public int getBlockNumber(long l) {
        this.locateBlockByPos(this.queriedBlockInfo, l);
        return this.queriedBlockInfo.blockNumber;
    }

    @Override
    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block13: {
            if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.in == null) {
                throw new $XZIOException("Stream closed");
            }
            if (this.exception != null) {
                throw this.exception;
            }
            n3 = 0;
            try {
                if (this.seekNeeded) {
                    this.seek();
                }
                if (this.endReached) {
                    return -1;
                }
                while (n2 > 0) {
                    int n4;
                    if (this.blockDecoder == null) {
                        this.seek();
                        if (this.endReached) break;
                    }
                    if ((n4 = this.blockDecoder.read(byArray, n, n2)) > 0) {
                        this.curPos += (long)n4;
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        continue;
                    }
                    if (n4 != -1) continue;
                    this.blockDecoder = null;
                }
            }
            catch (IOException iOException) {
                $CorruptedInputException $CorruptedInputException;
                if (iOException instanceof EOFException) {
                    $CorruptedInputException = new $CorruptedInputException();
                }
                this.exception = $CorruptedInputException;
                if (n3 != 0) break block13;
                throw $CorruptedInputException;
            }
        }
        return n3;
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            throw new $XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.endReached || this.seekNeeded || this.blockDecoder == null) {
            return 0;
        }
        return this.blockDecoder.available();
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean bl) throws IOException {
        if (this.in != null) {
            if (this.blockDecoder != null) {
                this.blockDecoder.close();
                this.blockDecoder = null;
            }
            try {
                if (bl) {
                    this.in.close();
                }
            }
            finally {
                this.in = null;
            }
        }
    }

    @Override
    public long length() {
        return this.uncompressedSize;
    }

    @Override
    public long position() throws IOException {
        if (this.in == null) {
            throw new $XZIOException("Stream closed");
        }
        return this.seekNeeded ? this.seekPos : this.curPos;
    }

    @Override
    public void seek(long l) throws IOException {
        if (this.in == null) {
            throw new $XZIOException("Stream closed");
        }
        if (l < 0L) {
            throw new $XZIOException("Negative seek position: " + l);
        }
        this.seekPos = l;
        this.seekNeeded = true;
    }

    public void seekToBlock(int n) throws IOException {
        if (this.in == null) {
            throw new $XZIOException("Stream closed");
        }
        if (n < 0 || n >= this.blockCount) {
            throw new $XZIOException("Invalid XZ Block number: " + n);
        }
        this.seekPos = this.getBlockPos(n);
        this.seekNeeded = true;
    }

    private void seek() throws IOException {
        if (!this.seekNeeded) {
            if (this.curBlockInfo.hasNext()) {
                this.curBlockInfo.setNext();
                this.initBlockDecoder();
                return;
            }
            this.seekPos = this.curPos;
        }
        this.seekNeeded = false;
        if (this.seekPos >= this.uncompressedSize) {
            this.curPos = this.seekPos;
            if (this.blockDecoder != null) {
                this.blockDecoder.close();
                this.blockDecoder = null;
            }
            this.endReached = true;
            return;
        }
        this.endReached = false;
        this.locateBlockByPos(this.curBlockInfo, this.seekPos);
        if (this.curPos <= this.curBlockInfo.uncompressedOffset || this.curPos > this.seekPos) {
            this.in.seek(this.curBlockInfo.compressedOffset);
            this.check = $Check.getInstance(this.curBlockInfo.getCheckType());
            this.initBlockDecoder();
            this.curPos = this.curBlockInfo.uncompressedOffset;
        }
        if (this.seekPos > this.curPos) {
            long l = this.seekPos - this.curPos;
            if (this.blockDecoder.skip(l) != l) {
                throw new $CorruptedInputException();
            }
            this.curPos = this.seekPos;
        }
    }

    private void locateBlockByPos($BlockInfo $BlockInfo, long l) {
        $IndexDecoder $IndexDecoder;
        if (l < 0L || l >= this.uncompressedSize) {
            throw new IndexOutOfBoundsException("Invalid uncompressed position: " + l);
        }
        int n = 0;
        while (!($IndexDecoder = this.streams.get(n)).hasUncompressedOffset(l)) {
            ++n;
        }
        $IndexDecoder.locateBlock($BlockInfo, l);
        assert (($BlockInfo.compressedOffset & 3L) == 0L);
        assert ($BlockInfo.uncompressedSize > 0L);
        assert (l >= $BlockInfo.uncompressedOffset);
        assert (l < $BlockInfo.uncompressedOffset + $BlockInfo.uncompressedSize);
    }

    private void locateBlockByNumber($BlockInfo $BlockInfo, int n) {
        if (n < 0 || n >= this.blockCount) {
            throw new IndexOutOfBoundsException("Invalid XZ Block number: " + n);
        }
        if ($BlockInfo.blockNumber == n) {
            return;
        }
        int n2 = 0;
        while (true) {
            $IndexDecoder $IndexDecoder;
            if (($IndexDecoder = this.streams.get(n2)).hasRecord(n)) {
                $IndexDecoder.setBlockInfo($BlockInfo, n);
                return;
            }
            ++n2;
        }
    }

    private void initBlockDecoder() throws IOException {
        try {
            if (this.blockDecoder != null) {
                this.blockDecoder.close();
                this.blockDecoder = null;
            }
            this.blockDecoder = new $BlockInputStream(this.in, this.check, this.verifyCheck, this.memoryLimit, this.curBlockInfo.unpaddedSize, this.curBlockInfo.uncompressedSize, this.arrayCache);
        }
        catch ($MemoryLimitException $MemoryLimitException) {
            assert (this.memoryLimit >= 0);
            throw new $MemoryLimitException($MemoryLimitException.getMemoryNeeded() + this.indexMemoryUsage, this.memoryLimit + this.indexMemoryUsage);
        }
        catch ($IndexIndicatorException $IndexIndicatorException) {
            throw new $CorruptedInputException();
        }
    }
}

