/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.org.tukaani.xz;

import de.softwareforge.testing.org.tukaani.xz.$ArrayCache;
import de.softwareforge.testing.org.tukaani.xz.$BlockOutputStream;
import de.softwareforge.testing.org.tukaani.xz.$FilterCoder;
import de.softwareforge.testing.org.tukaani.xz.$FilterEncoder;
import de.softwareforge.testing.org.tukaani.xz.$FilterOptions;
import de.softwareforge.testing.org.tukaani.xz.$FinishableOutputStream;
import de.softwareforge.testing.org.tukaani.xz.$RawCoder;
import de.softwareforge.testing.org.tukaani.xz.$UnsupportedOptionsException;
import de.softwareforge.testing.org.tukaani.xz.$XZ;
import de.softwareforge.testing.org.tukaani.xz.$XZIOException;
import de.softwareforge.testing.org.tukaani.xz.check.$Check;
import de.softwareforge.testing.org.tukaani.xz.common.$EncoderUtil;
import de.softwareforge.testing.org.tukaani.xz.common.$StreamFlags;
import de.softwareforge.testing.org.tukaani.xz.index.$IndexEncoder;
import java.io.IOException;
import java.io.OutputStream;

public class $XZOutputStream
extends $FinishableOutputStream {
    private final $ArrayCache arrayCache;
    private OutputStream out;
    private final $StreamFlags streamFlags = new $StreamFlags();
    private final $Check check;
    private final $IndexEncoder index = new $IndexEncoder();
    private $BlockOutputStream blockEncoder = null;
    private $FilterEncoder[] filters;
    private boolean filtersSupportFlushing;
    private IOException exception = null;
    private boolean finished = false;
    private final byte[] tempBuf = new byte[1];

    public $XZOutputStream(OutputStream outputStream, $FilterOptions $FilterOptions) throws IOException {
        this(outputStream, $FilterOptions, 4);
    }

    public $XZOutputStream(OutputStream outputStream, $FilterOptions $FilterOptions, $ArrayCache $ArrayCache) throws IOException {
        this(outputStream, $FilterOptions, 4, $ArrayCache);
    }

    public $XZOutputStream(OutputStream outputStream, $FilterOptions $FilterOptions, int n) throws IOException {
        this(outputStream, new $FilterOptions[]{$FilterOptions}, n);
    }

    public $XZOutputStream(OutputStream outputStream, $FilterOptions $FilterOptions, int n, $ArrayCache $ArrayCache) throws IOException {
        this(outputStream, new $FilterOptions[]{$FilterOptions}, n, $ArrayCache);
    }

    public $XZOutputStream(OutputStream outputStream, $FilterOptions[] $FilterOptionsArray) throws IOException {
        this(outputStream, $FilterOptionsArray, 4);
    }

    public $XZOutputStream(OutputStream outputStream, $FilterOptions[] $FilterOptionsArray, $ArrayCache $ArrayCache) throws IOException {
        this(outputStream, $FilterOptionsArray, 4, $ArrayCache);
    }

    public $XZOutputStream(OutputStream outputStream, $FilterOptions[] $FilterOptionsArray, int n) throws IOException {
        this(outputStream, $FilterOptionsArray, n, $ArrayCache.getDefaultCache());
    }

    public $XZOutputStream(OutputStream outputStream, $FilterOptions[] $FilterOptionsArray, int n, $ArrayCache $ArrayCache) throws IOException {
        this.arrayCache = $ArrayCache;
        this.out = outputStream;
        this.updateFilters($FilterOptionsArray);
        this.streamFlags.checkType = n;
        this.check = $Check.getInstance(n);
        this.encodeStreamHeader();
    }

    public void updateFilters($FilterOptions $FilterOptions) throws $XZIOException {
        $FilterOptions[] $FilterOptionsArray = new $FilterOptions[]{$FilterOptions};
        this.updateFilters($FilterOptionsArray);
    }

    public void updateFilters($FilterOptions[] $FilterOptionsArray) throws $XZIOException {
        if (this.blockEncoder != null) {
            throw new $UnsupportedOptionsException("Changing filter options in the middle of a XZ Block not implemented");
        }
        if ($FilterOptionsArray.length < 1 || $FilterOptionsArray.length > 4) {
            throw new $UnsupportedOptionsException("XZ filter chain must be 1-4 filters");
        }
        this.filtersSupportFlushing = true;
        $FilterCoder[] $FilterCoderArray = new $FilterEncoder[$FilterOptionsArray.length];
        for (int i = 0; i < $FilterOptionsArray.length; ++i) {
            $FilterCoderArray[i] = $FilterOptionsArray[i].getFilterEncoder();
            this.filtersSupportFlushing &= $FilterCoderArray[i].supportsFlushing();
        }
        $RawCoder.validate($FilterCoderArray);
        this.filters = $FilterCoderArray;
    }

    @Override
    public void write(int n) throws IOException {
        this.tempBuf[0] = (byte)n;
        this.write(this.tempBuf, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new $XZIOException("Stream finished or closed");
        }
        try {
            if (this.blockEncoder == null) {
                this.blockEncoder = new $BlockOutputStream(this.out, this.filters, this.check, this.arrayCache);
            }
            this.blockEncoder.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    public void endBlock() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new $XZIOException("Stream finished or closed");
        }
        if (this.blockEncoder != null) {
            try {
                this.blockEncoder.finish();
                this.index.add(this.blockEncoder.getUnpaddedSize(), this.blockEncoder.getUncompressedSize());
                this.blockEncoder = null;
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new $XZIOException("Stream finished or closed");
        }
        try {
            if (this.blockEncoder != null) {
                if (this.filtersSupportFlushing) {
                    this.blockEncoder.flush();
                } else {
                    this.endBlock();
                    this.out.flush();
                }
            } else {
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    @Override
    public void finish() throws IOException {
        if (!this.finished) {
            this.endBlock();
            try {
                this.index.encode(this.out);
                this.encodeStreamFooter();
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
            this.finished = true;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            block6: {
                try {
                    this.finish();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    if (this.exception != null) break block6;
                    this.exception = iOException;
                }
            }
            this.out = null;
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private void encodeStreamFlags(byte[] byArray, int n) {
        byArray[n] = 0;
        byArray[n + 1] = (byte)this.streamFlags.checkType;
    }

    private void encodeStreamHeader() throws IOException {
        this.out.write($XZ.HEADER_MAGIC);
        byte[] byArray = new byte[2];
        this.encodeStreamFlags(byArray, 0);
        this.out.write(byArray);
        $EncoderUtil.writeCRC32(this.out, byArray);
    }

    private void encodeStreamFooter() throws IOException {
        byte[] byArray = new byte[6];
        long l = this.index.getIndexSize() / 4L - 1L;
        for (int i = 0; i < 4; ++i) {
            byArray[i] = (byte)(l >>> i * 8);
        }
        this.encodeStreamFlags(byArray, 4);
        $EncoderUtil.writeCRC32(this.out, byArray);
        this.out.write(byArray);
        this.out.write($XZ.FOOTER_MAGIC);
    }
}

