/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.org.tukaani.xz.common;

import de.softwareforge.testing.org.tukaani.xz.$CorruptedInputException;
import de.softwareforge.testing.org.tukaani.xz.$UnsupportedOptionsException;
import de.softwareforge.testing.org.tukaani.xz.$XZ;
import de.softwareforge.testing.org.tukaani.xz.$XZFormatException;
import de.softwareforge.testing.org.tukaani.xz.common.$StreamFlags;
import de.softwareforge.testing.org.tukaani.xz.common.$Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class $DecoderUtil
extends $Util {
    public static boolean isCRC32Valid(byte[] byArray, int n, int n2, int n3) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, n, n2);
        long l = cRC32.getValue();
        for (int i = 0; i < 4; ++i) {
            if ((byte)(l >>> i * 8) == byArray[n3 + i]) continue;
            return false;
        }
        return true;
    }

    public static $StreamFlags decodeStreamHeader(byte[] byArray) throws IOException {
        for (int i = 0; i < $XZ.HEADER_MAGIC.length; ++i) {
            if (byArray[i] == $XZ.HEADER_MAGIC[i]) continue;
            throw new $XZFormatException();
        }
        if (!$DecoderUtil.isCRC32Valid(byArray, $XZ.HEADER_MAGIC.length, 2, $XZ.HEADER_MAGIC.length + 2)) {
            throw new $CorruptedInputException("XZ Stream Header is corrupt");
        }
        try {
            return $DecoderUtil.decodeStreamFlags(byArray, $XZ.HEADER_MAGIC.length);
        }
        catch ($UnsupportedOptionsException $UnsupportedOptionsException) {
            throw new $UnsupportedOptionsException("Unsupported options in XZ Stream Header");
        }
    }

    public static $StreamFlags decodeStreamFooter(byte[] byArray) throws IOException {
        $StreamFlags $StreamFlags;
        if (byArray[10] != $XZ.FOOTER_MAGIC[0] || byArray[11] != $XZ.FOOTER_MAGIC[1]) {
            throw new $CorruptedInputException("XZ Stream Footer is corrupt");
        }
        if (!$DecoderUtil.isCRC32Valid(byArray, 4, 6, 0)) {
            throw new $CorruptedInputException("XZ Stream Footer is corrupt");
        }
        try {
            $StreamFlags = $DecoderUtil.decodeStreamFlags(byArray, 8);
        }
        catch ($UnsupportedOptionsException $UnsupportedOptionsException) {
            throw new $UnsupportedOptionsException("Unsupported options in XZ Stream Footer");
        }
        $StreamFlags.backwardSize = 0L;
        for (int i = 0; i < 4; ++i) {
            $StreamFlags.backwardSize |= (long)((byArray[i + 4] & 0xFF) << i * 8);
        }
        $StreamFlags.backwardSize = ($StreamFlags.backwardSize + 1L) * 4L;
        return $StreamFlags;
    }

    private static $StreamFlags decodeStreamFlags(byte[] byArray, int n) throws $UnsupportedOptionsException {
        if (byArray[n] != 0 || (byArray[n + 1] & 0xFF) >= 16) {
            throw new $UnsupportedOptionsException();
        }
        $StreamFlags $StreamFlags = new $StreamFlags();
        $StreamFlags.checkType = byArray[n + 1];
        return $StreamFlags;
    }

    public static boolean areStreamFlagsEqual($StreamFlags $StreamFlags, $StreamFlags $StreamFlags2) {
        return $StreamFlags.checkType == $StreamFlags2.checkType;
    }

    public static long decodeVLI(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        long l = n & 0x7F;
        int n2 = 0;
        while ((n & 0x80) != 0) {
            if (++n2 >= 9) {
                throw new $CorruptedInputException();
            }
            n = inputStream.read();
            if (n == -1) {
                throw new EOFException();
            }
            if (n == 0) {
                throw new $CorruptedInputException();
            }
            l |= (long)(n & 0x7F) << n2 * 7;
        }
        return l;
    }
}

