/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.org.tukaani.xz.index;

import de.softwareforge.testing.org.tukaani.xz.$CorruptedInputException;
import de.softwareforge.testing.org.tukaani.xz.$MemoryLimitException;
import de.softwareforge.testing.org.tukaani.xz.$SeekableInputStream;
import de.softwareforge.testing.org.tukaani.xz.$UnsupportedOptionsException;
import de.softwareforge.testing.org.tukaani.xz.common.$DecoderUtil;
import de.softwareforge.testing.org.tukaani.xz.common.$StreamFlags;
import de.softwareforge.testing.org.tukaani.xz.index.$BlockInfo;
import de.softwareforge.testing.org.tukaani.xz.index.$IndexBase;
import java.io.EOFException;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

public class $IndexDecoder
extends $IndexBase {
    private final $StreamFlags streamFlags;
    private final long streamPadding;
    private final int memoryUsage;
    private final long[] unpadded;
    private final long[] uncompressed;
    private long largestBlockSize = 0L;
    private int recordOffset = 0;
    private long compressedOffset = 0L;
    private long uncompressedOffset = 0L;

    public $IndexDecoder($SeekableInputStream $SeekableInputStream, $StreamFlags $StreamFlags, long l, int n) throws IOException {
        super(new $CorruptedInputException("XZ Index is corrupt"));
        int n2;
        this.streamFlags = $StreamFlags;
        this.streamPadding = l;
        long l2 = $SeekableInputStream.position() + $StreamFlags.backwardSize - 4L;
        CRC32 cRC32 = new CRC32();
        CheckedInputStream checkedInputStream = new CheckedInputStream($SeekableInputStream, cRC32);
        if (checkedInputStream.read() != 0) {
            throw new $CorruptedInputException("XZ Index is corrupt");
        }
        try {
            long l3 = $DecoderUtil.decodeVLI(checkedInputStream);
            if (l3 >= $StreamFlags.backwardSize / 2L) {
                throw new $CorruptedInputException("XZ Index is corrupt");
            }
            if (l3 > Integer.MAX_VALUE) {
                throw new $UnsupportedOptionsException("XZ Index has over 2147483647 Records");
            }
            this.memoryUsage = 1 + (int)((16L * l3 + 1023L) / 1024L);
            if (n >= 0 && this.memoryUsage > n) {
                throw new $MemoryLimitException(this.memoryUsage, n);
            }
            this.unpadded = new long[(int)l3];
            this.uncompressed = new long[(int)l3];
            int n3 = 0;
            for (n2 = (int)l3; n2 > 0; --n2) {
                long l4 = $DecoderUtil.decodeVLI(checkedInputStream);
                long l5 = $DecoderUtil.decodeVLI(checkedInputStream);
                if ($SeekableInputStream.position() > l2) {
                    throw new $CorruptedInputException("XZ Index is corrupt");
                }
                this.unpadded[n3] = this.blocksSum + l4;
                this.uncompressed[n3] = this.uncompressedSum + l5;
                super.add(l4, l5);
                assert ((long)(++n3) == this.recordCount);
                if (this.largestBlockSize >= l5) continue;
                this.largestBlockSize = l5;
            }
        }
        catch (EOFException eOFException) {
            throw new $CorruptedInputException("XZ Index is corrupt");
        }
        int n4 = this.getIndexPaddingSize();
        if ($SeekableInputStream.position() + (long)n4 != l2) {
            throw new $CorruptedInputException("XZ Index is corrupt");
        }
        while (n4-- > 0) {
            if (checkedInputStream.read() == 0) continue;
            throw new $CorruptedInputException("XZ Index is corrupt");
        }
        long l6 = cRC32.getValue();
        for (n2 = 0; n2 < 4; ++n2) {
            if ((l6 >>> n2 * 8 & 0xFFL) == (long)$SeekableInputStream.read()) continue;
            throw new $CorruptedInputException("XZ Index is corrupt");
        }
    }

    public void setOffsets($IndexDecoder $IndexDecoder) {
        this.recordOffset = $IndexDecoder.recordOffset + (int)$IndexDecoder.recordCount;
        this.compressedOffset = $IndexDecoder.compressedOffset + $IndexDecoder.getStreamSize() + $IndexDecoder.streamPadding;
        assert ((this.compressedOffset & 3L) == 0L);
        this.uncompressedOffset = $IndexDecoder.uncompressedOffset + $IndexDecoder.uncompressedSum;
    }

    public int getMemoryUsage() {
        return this.memoryUsage;
    }

    public $StreamFlags getStreamFlags() {
        return this.streamFlags;
    }

    public int getRecordCount() {
        return (int)this.recordCount;
    }

    public long getUncompressedSize() {
        return this.uncompressedSum;
    }

    public long getLargestBlockSize() {
        return this.largestBlockSize;
    }

    public boolean hasUncompressedOffset(long l) {
        return l >= this.uncompressedOffset && l < this.uncompressedOffset + this.uncompressedSum;
    }

    public boolean hasRecord(int n) {
        return n >= this.recordOffset && (long)n < (long)this.recordOffset + this.recordCount;
    }

    public void locateBlock($BlockInfo $BlockInfo, long l) {
        assert (l >= this.uncompressedOffset);
        assert ((l -= this.uncompressedOffset) < this.uncompressedSum);
        int n = 0;
        int n2 = this.unpadded.length - 1;
        while (n < n2) {
            int n3 = n + (n2 - n) / 2;
            if (this.uncompressed[n3] <= l) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
        }
        this.setBlockInfo($BlockInfo, this.recordOffset + n);
    }

    public void setBlockInfo($BlockInfo $BlockInfo, int n) {
        assert (n >= this.recordOffset);
        assert ((long)(n - this.recordOffset) < this.recordCount);
        $BlockInfo.index = this;
        $BlockInfo.blockNumber = n;
        int n2 = n - this.recordOffset;
        if (n2 == 0) {
            $BlockInfo.compressedOffset = 0L;
            $BlockInfo.uncompressedOffset = 0L;
        } else {
            $BlockInfo.compressedOffset = this.unpadded[n2 - 1] + 3L & 0xFFFFFFFFFFFFFFFCL;
            $BlockInfo.uncompressedOffset = this.uncompressed[n2 - 1];
        }
        $BlockInfo.unpaddedSize = this.unpadded[n2] - $BlockInfo.compressedOffset;
        $BlockInfo.uncompressedSize = this.uncompressed[n2] - $BlockInfo.uncompressedOffset;
        $BlockInfo.compressedOffset += this.compressedOffset + 12L;
        $BlockInfo.uncompressedOffset += this.uncompressedOffset;
    }
}

