/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.softwareforge.testing.postgres.embedded.DatabaseInfo;
import de.softwareforge.testing.postgres.embedded.DatabasePreparer;
import de.softwareforge.testing.postgres.embedded.EmbeddedPostgres;
import de.softwareforge.testing.postgres.embedded.EmbeddedPostgresPreparer;
import de.softwareforge.testing.postgres.embedded.EmbeddedUtil;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseManager
implements AutoCloseable {
    private static final String PG_DEFAULT_ENCODING = "utf8";
    public static final Logger LOG = LoggerFactory.getLogger(DatabaseManager.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean started = new AtomicBoolean();
    private final Set<EmbeddedPostgresPreparer<DataSource>> databasePreparers;
    private final Set<EmbeddedPostgresPreparer<EmbeddedPostgres.Builder>> instancePreparers;
    private final boolean multiMode;
    private volatile InstanceProvider instanceProvider = null;
    private volatile EmbeddedPostgres pg = null;

    private DatabaseManager(Set<EmbeddedPostgresPreparer<DataSource>> databasePreparers, Set<EmbeddedPostgresPreparer<EmbeddedPostgres.Builder>> instancePreparers, boolean multiMode) {
        this.databasePreparers = (Set)Preconditions.checkNotNull(databasePreparers, (Object)"databasePreparers is null");
        this.instancePreparers = (Set)Preconditions.checkNotNull(instancePreparers, (Object)"instancePreparers is null");
        this.multiMode = multiMode;
    }

    @NonNull
    public static Builder<DatabaseManager> multiDatabases() {
        return new DatabaseManagerBuilder(true);
    }

    @NonNull
    public static Builder<DatabaseManager> singleDatabase() {
        return new DatabaseManagerBuilder(false);
    }

    @NonNull
    public DatabaseManager start() throws IOException, SQLException {
        if (!this.started.getAndSet(true)) {
            DataSource dataSource;
            EmbeddedPostgres.Builder builder = EmbeddedPostgres.builder();
            for (EmbeddedPostgresPreparer<EmbeddedPostgres.Builder> instancePreparer : this.instancePreparers) {
                instancePreparer.prepare(builder);
            }
            this.pg = builder.build();
            if (this.multiMode) {
                dataSource = this.pg.createTemplateDataSource();
                this.instanceProvider = new InstanceProviderPipeline();
            } else {
                dataSource = this.pg.createDefaultDataSource();
                this.instanceProvider = () -> this.pg.createDefaultDatabaseInfo();
            }
            for (EmbeddedPostgresPreparer<DataSource> databasePreparer : this.databasePreparers) {
                databasePreparer.prepare(dataSource);
            }
            this.instanceProvider.start();
        }
        return this;
    }

    @Override
    public void close() throws Exception {
        Preconditions.checkState((boolean)this.started.get(), (Object)"not yet started!");
        if (!this.closed.getAndSet(true)) {
            this.instanceProvider.close();
            this.pg.close();
        }
    }

    @NonNull
    public DatabaseInfo getDatabaseInfo() throws SQLException {
        Preconditions.checkState((boolean)this.started.get(), (Object)"not yet started!");
        DatabaseInfo databaseInfo = this.instanceProvider.get();
        if (databaseInfo.exception().isPresent()) {
            throw databaseInfo.exception().get();
        }
        return databaseInfo;
    }

    @NonNull
    public EmbeddedPostgres getEmbeddedPostgres() {
        Preconditions.checkState((boolean)this.started.get(), (Object)"not yet started!");
        return this.pg;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    private static void createDatabase(DataSource dataSource, String databaseName) throws SQLException {
        try (Connection c = dataSource.getConnection();
             Statement stmt = c.createStatement();){
            stmt.executeUpdate(String.format("CREATE DATABASE %s OWNER %s ENCODING = '%s'", databaseName, "postgres", PG_DEFAULT_ENCODING));
        }
    }

    private static interface InstanceProvider
    extends Supplier<DatabaseInfo>,
    AutoCloseable {
        default public void start() {
        }

        @Override
        default public void close() {
        }

        @Override
        public DatabaseInfo get();
    }

    public static final class DatabaseManagerBuilder
    extends Builder<DatabaseManager> {
        public DatabaseManagerBuilder(boolean multiMode) {
            super(multiMode);
        }

        @Override
        @NonNull
        public DatabaseManager build() {
            return new DatabaseManager((Set<EmbeddedPostgresPreparer<DataSource>>)this.databasePreparers.build(), (Set<EmbeddedPostgresPreparer<EmbeddedPostgres.Builder>>)this.instancePreparers.build(), this.multiMode);
        }
    }

    private final class InstanceProviderPipeline
    implements InstanceProvider,
    Runnable {
        private final ExecutorService executor;
        private final SynchronousQueue<DatabaseInfo> nextDatabase = new SynchronousQueue();
        private final AtomicBoolean closed = new AtomicBoolean();

        InstanceProviderPipeline() {
            this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("instance-creator-" + DatabaseManager.this.pg.instanceId() + "-%d").build());
        }

        @Override
        public void start() {
            this.executor.submit(this);
        }

        @Override
        public void close() {
            if (!this.closed.getAndSet(true)) {
                this.executor.shutdownNow();
            }
        }

        @Override
        public void run() {
            while (!this.closed.get()) {
                try {
                    String newDbName = EmbeddedUtil.randomLowercase(12);
                    try {
                        DatabaseManager.createDatabase(DatabaseManager.this.pg.createDefaultDataSource(), newDbName);
                        this.nextDatabase.put(DatabaseInfo.builder().dbName(newDbName).port(DatabaseManager.this.pg.getPort()).connectionProperties(DatabaseManager.this.pg.getConnectionProperties()).build());
                    }
                    catch (SQLException e) {
                        if (e.getSQLState().equals("57P01")) continue;
                        LOG.warn("Caught SQL Exception (" + e.getSQLState() + "):", (Throwable)e);
                        this.nextDatabase.put(DatabaseInfo.forException(e));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (Throwable t) {
                    LOG.warn("Caught Throwable in instance provider loop:", t);
                }
            }
        }

        @Override
        public DatabaseInfo get() {
            try {
                return this.nextDatabase.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }
    }

    public static abstract class Builder<T> {
        protected ImmutableSet.Builder<EmbeddedPostgresPreparer<DataSource>> databasePreparers = ImmutableSet.builder();
        protected ImmutableSet.Builder<EmbeddedPostgresPreparer<EmbeddedPostgres.Builder>> instancePreparers = ImmutableSet.builder();
        protected final boolean multiMode;

        protected Builder(boolean multiMode) {
            this.multiMode = multiMode;
        }

        @Deprecated
        @NonNull
        public Builder<T> withPreparer(@NonNull DatabasePreparer databasePreparer) {
            Preconditions.checkNotNull((Object)databasePreparer, (Object)"databasePreparer is null");
            return this.withDatabasePreparer(databasePreparer::prepare);
        }

        @NonNull
        public Builder<T> withDatabasePreparer(@NonNull EmbeddedPostgresPreparer<DataSource> databasePreparer) {
            this.databasePreparers.add((Object)((EmbeddedPostgresPreparer)Preconditions.checkNotNull(databasePreparer, (Object)"databasePreparer is null")));
            return this;
        }

        @NonNull
        public Builder<T> withDatabasePreparers(@NonNull Set<EmbeddedPostgresPreparer<DataSource>> databasePreparers) {
            this.databasePreparers.addAll((Iterable)Preconditions.checkNotNull(databasePreparers, (Object)"databasePreparers is null"));
            return this;
        }

        @NonNull
        public Builder<T> withInstancePreparer(@NonNull EmbeddedPostgresPreparer<EmbeddedPostgres.Builder> instancePreparer) {
            this.instancePreparers.add((Object)((EmbeddedPostgresPreparer)Preconditions.checkNotNull(instancePreparer, (Object)"instancePreparer is null")));
            return this;
        }

        @NonNull
        public Builder<T> withInstancePreparers(@NonNull Set<EmbeddedPostgresPreparer<EmbeddedPostgres.Builder>> instancePreparers) {
            this.instancePreparers.addAll((Iterable)Preconditions.checkNotNull(instancePreparers, (Object)"instancePreparers is null"));
            return this;
        }

        @Deprecated
        @NonNull
        public Builder<T> withCustomizer(@NonNull EmbeddedPostgres.BuilderCustomizer customizer) {
            Preconditions.checkNotNull((Object)customizer, (Object)"customizer is null");
            this.instancePreparers.add(customizer::customize);
            return this;
        }

        @NonNull
        public abstract T build();
    }
}

