/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import de.softwareforge.testing.postgres.embedded.EmbeddedPostgresPreparer;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlywayPreparer
implements EmbeddedPostgresPreparer<DataSource> {
    private static final Logger LOG = LoggerFactory.getLogger(FlywayPreparer.class);
    private final ImmutableList.Builder<Consumer<FluentConfiguration>> customizers = ImmutableList.builder();

    @NonNull
    public static FlywayPreparer forClasspathLocation(String ... locations) {
        FlywayPreparer preparer = new FlywayPreparer();
        preparer.addCustomizer(c -> c.locations(locations));
        return preparer;
    }

    @NonNull
    public FlywayPreparer addCustomizer(@NonNull Consumer<FluentConfiguration> customizer) {
        Preconditions.checkNotNull(customizer, (Object)"customizer is null");
        this.customizers.add(customizer);
        return this;
    }

    @NonNull
    public FlywayPreparer addCustomizers(@NonNull Set<Consumer<FluentConfiguration>> customizers) {
        Preconditions.checkNotNull(customizers, (Object)"customizers is null");
        customizers.addAll(customizers);
        return this;
    }

    @Deprecated
    @NonNull
    public FlywayPreparer customize(@NonNull Consumer<FluentConfiguration> customizer) {
        return this.addCustomizer(customizer);
    }

    @Override
    public void prepare(@NonNull DataSource dataSource) throws IOException {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource is null");
        try {
            FluentConfiguration config = Flyway.configure();
            this.customizers.build().forEach(c -> c.accept(config));
            config.dataSource(dataSource);
            Flyway flyway = config.load();
            flyway.migrate();
        }
        catch (FlywayException e) {
            throw new IOException(e);
        }
    }
}

