/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.io.Closeables;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;

class ProcessOutputLogger
implements Closeable {
    private final Logger logger;
    private final ListeningExecutorService executorService;

    ProcessOutputLogger(Logger errorLogger) {
        this.logger = errorLogger;
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("logger-thread-%d").build()));
    }

    @Override
    public void close() {
        this.executorService.shutdownNow();
    }

    StreamCapture captureStreamAsLog() {
        return new StreamCapture(arg_0 -> ((Logger)this.logger).debug(arg_0));
    }

    StreamCapture captureStreamAsConsumer(Consumer<String> consumer) {
        return new StreamCapture(consumer);
    }

    class StreamCapture
    implements BiConsumer<String, InputStream> {
        private final Consumer<String> consumer;
        private volatile Future<?> completionFuture = null;

        private StreamCapture(Consumer<String> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void accept(String name, InputStream inputStream) {
            this.completionFuture = ProcessOutputLogger.this.executorService.submit((Runnable)new LogRunnable(name, inputStream, this.consumer));
        }

        public Future<?> getCompletion() {
            return this.completionFuture;
        }
    }

    private class LogRunnable
    implements Runnable {
        private final BufferedReader reader;
        private final String name;
        private final Consumer<String> consumer;

        private LogRunnable(String name, InputStream inputStream, Consumer<String> consumer) {
            this.name = name;
            this.reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            this.consumer = consumer;
        }

        @Override
        public void run() {
            String oldName = Thread.currentThread().getName();
            Thread.currentThread().setName(this.name);
            try {
                try {
                    this.reader.lines().forEach(this.consumer::accept);
                }
                catch (UncheckedIOException e) {
                    ProcessOutputLogger.this.logger.error("while reading output:", (Throwable)e);
                }
            }
            finally {
                Closeables.closeQuietly((Reader)this.reader);
                Thread.currentThread().setName(oldName + " (" + this.name + ")");
            }
        }
    }
}

