/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.base.Preconditions;
import de.softwareforge.testing.org.apache.commons.compress.archivers.tar.$TarArchiveEntry;
import de.softwareforge.testing.org.apache.commons.compress.archivers.tar.$TarArchiveInputStream;
import de.softwareforge.testing.org.tukaani.xz.$XZInputStream;
import de.softwareforge.testing.postgres.embedded.EmbeddedUtil;
import de.softwareforge.testing.postgres.embedded.NativeBinaryLocator;
import de.softwareforge.testing.postgres.embedded.NativeBinaryManager;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Phaser;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TarXzCompressedBinaryManager
implements NativeBinaryManager {
    private static final Logger LOG = LoggerFactory.getLogger(TarXzCompressedBinaryManager.class);
    private static final Map<NativeBinaryLocator, File> KNOWN_INSTALLATIONS = new ConcurrentHashMap<NativeBinaryLocator, File>();
    private final Lock prepareBinariesLock = new ReentrantLock();
    private File installationBaseDirectory = EmbeddedUtil.getWorkingDirectory();
    private String lockFileName = "epg-lock";
    private final NativeBinaryLocator nativeBinaryLocator;

    public TarXzCompressedBinaryManager(@NonNull NativeBinaryLocator nativeBinaryLocator) {
        this.nativeBinaryLocator = (NativeBinaryLocator)Preconditions.checkNotNull((Object)nativeBinaryLocator, (Object)"nativeBinaryLocator is null");
        Preconditions.checkState((boolean)this.installationBaseDirectory.setWritable(true, false), (String)"Could not make install base directory %s writable!", (Object)this.installationBaseDirectory);
    }

    @Override
    public void setInstallationBaseDirectory(File installationBaseDirectory) {
        this.installationBaseDirectory = (File)Preconditions.checkNotNull((Object)installationBaseDirectory, (Object)"installationBaseDirectory is null");
        Preconditions.checkState((boolean)this.installationBaseDirectory.setWritable(true, false), (String)"Could not make install base directory %s writable!", (Object)this.installationBaseDirectory);
    }

    public void setLockFileName(String lockFileName) {
        this.lockFileName = (String)Preconditions.checkNotNull((Object)lockFileName, (Object)"lockFileName is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public File getLocation() throws IOException {
        File installationDirectory = KNOWN_INSTALLATIONS.get(this.nativeBinaryLocator);
        if (installationDirectory != null && installationDirectory.exists()) {
            return installationDirectory;
        }
        this.prepareBinariesLock.lock();
        try {
            block29: {
                String installationIdentifier = this.nativeBinaryLocator.getIdentifier();
                installationDirectory = new File(this.installationBaseDirectory, installationIdentifier);
                EmbeddedUtil.mkdirs(installationDirectory);
                File unpackLockFile = new File(installationDirectory, this.lockFileName);
                File installationExistsFile = new File(installationDirectory, ".exists");
                if (!installationExistsFile.exists()) {
                    try {
                        block28: {
                            try (FileOutputStream lockStream = new FileOutputStream(unpackLockFile);
                                 FileLock unpackLock = lockStream.getChannel().tryLock();){
                                if (unpackLock != null) {
                                    Preconditions.checkState((!installationExistsFile.exists() ? 1 : 0) != 0, (Object)("unpack lock acquired but .exists file is present " + installationExistsFile));
                                    LOG.info("extracting archive...");
                                    try (InputStream archiveStream = this.nativeBinaryLocator.getInputStream();){
                                        TarXzCompressedBinaryManager.extractTxz(archiveStream, installationDirectory.getPath());
                                        Preconditions.checkState((boolean)installationExistsFile.createNewFile(), (String)"couldn't create %s file!", (Object)installationExistsFile);
                                        break block28;
                                    }
                                }
                                int maxAttempts = 60;
                                while (!installationExistsFile.exists() && --maxAttempts > 0) {
                                    Thread.sleep(1000L);
                                }
                                Preconditions.checkState((boolean)installationExistsFile.exists(), (Object)"Waited 60 seconds for archive to be unpacked but it never finished!");
                            }
                        }
                        if (!unpackLockFile.exists() || unpackLockFile.delete()) break block29;
                    }
                    catch (Throwable throwable) {
                        if (!unpackLockFile.exists()) throw throwable;
                        if (unpackLockFile.delete()) throw throwable;
                        LOG.error(String.format("could not remove lock file %s", unpackLockFile.getAbsolutePath()));
                        throw throwable;
                    }
                    LOG.error(String.format("could not remove lock file %s", unpackLockFile.getAbsolutePath()));
                }
            }
            KNOWN_INSTALLATIONS.putIfAbsent(this.nativeBinaryLocator, installationDirectory);
            LOG.debug(String.format("Unpacked archive at %s", installationDirectory));
            File file = installationDirectory;
            return file;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        finally {
            this.prepareBinariesLock.lock();
        }
    }

    private static void extractTxz(InputStream stream, String targetDir) throws IOException {
        try ($XZInputStream xzIn = new $XZInputStream(stream);
             $TarArchiveInputStream tarIn = new $TarArchiveInputStream(xzIn);){
            $TarArchiveEntry entry;
            final Phaser phaser = new Phaser(1);
            while ((entry = tarIn.getNextTarEntry()) != null) {
                String individualFile = entry.getName();
                final File fsObject = new File(targetDir, individualFile);
                Path fsPath = fsObject.toPath();
                if (Files.exists(fsPath, LinkOption.NOFOLLOW_LINKS) && !Files.isDirectory(fsPath, LinkOption.NOFOLLOW_LINKS)) {
                    Files.delete(fsPath);
                    LOG.debug(String.format("Deleting existing entry %s", fsPath));
                }
                if (entry.isSymbolicLink() || entry.isLink()) {
                    Path target = FileSystems.getDefault().getPath(entry.getLinkName(), new String[0]);
                    Files.createSymbolicLink(fsPath, target, new FileAttribute[0]);
                } else if (entry.isFile()) {
                    byte[] content = new byte[(int)entry.getSize()];
                    int read = tarIn.read(content, 0, content.length);
                    Preconditions.checkState((read != -1 ? 1 : 0) != 0, (String)"could not read %s", (Object)individualFile);
                    EmbeddedUtil.mkdirs(fsObject.getParentFile());
                    AsynchronousFileChannel fileChannel = AsynchronousFileChannel.open(fsPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                    ByteBuffer buffer = ByteBuffer.wrap(content);
                    phaser.register();
                    fileChannel.write(buffer, 0L, fileChannel, new CompletionHandler<Integer, Channel>(){

                        @Override
                        public void completed(Integer written, Channel channel) {
                            this.closeChannel(channel);
                        }

                        @Override
                        public void failed(Throwable error, Channel channel) {
                            LOG.error(String.format("could not write file %s", fsObject.getAbsolutePath()), error);
                            this.closeChannel(channel);
                        }

                        private void closeChannel(Channel channel) {
                            try {
                                channel.close();
                            }
                            catch (IOException e) {
                                LOG.error("While closing channel:", (Throwable)e);
                            }
                            finally {
                                phaser.arriveAndDeregister();
                            }
                        }
                    });
                } else if (entry.isDirectory()) {
                    EmbeddedUtil.mkdirs(fsObject);
                } else {
                    throw new IOException(String.format("Unsupported entry in tar file found: %s", individualFile));
                }
                if (!individualFile.startsWith("bin/") && !individualFile.startsWith("./bin/") || fsObject.setExecutable(true, false)) continue;
                throw new IOException(String.format("Could not make %s executable!", individualFile));
            }
            phaser.arriveAndAwaitAdvance();
        }
    }
}

