/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.embedded;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import de.softwareforge.testing.maven.MavenArtifactLoader;
import de.softwareforge.testing.postgres.embedded.EmbeddedUtil;
import de.softwareforge.testing.postgres.embedded.NativeBinaryLocator;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZonkyIOPostgresLocator
implements NativeBinaryLocator {
    private static final String ZONKY_GROUP_ID = "io.zonky.test.postgres";
    private static final String ZONKY_ARTIFACT_ID_TEMPLATE = "embedded-postgres-binaries-%s-%s";
    public static final Logger LOG = LoggerFactory.getLogger(ZonkyIOPostgresLocator.class);
    private static final boolean PREFER_NATIVE = Boolean.getBoolean("pg-embedded.prefer-native");
    private final String architecture;
    private final String os;
    private final String serverVersion;
    private final MavenArtifactLoader artifactLoader = new MavenArtifactLoader();
    private final Supplier<File> fileSupplier = Suppliers.memoize(this::loadArtifact);

    ZonkyIOPostgresLocator(String serverVersion) {
        this.serverVersion = (String)Preconditions.checkNotNull((Object)serverVersion, (Object)"serverVersion is null");
        this.os = ZonkyIOPostgresLocator.computeOS();
        this.architecture = ZonkyIOPostgresLocator.computeTarXzArchitectureName();
        LOG.debug(String.format("Detected a %s %s system, using PostgreSQL version %s", this.architecture, this.os, serverVersion));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            File artifactFile = this.fileSupplier.get();
            return this.createJarStream(artifactFile);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    @Override
    public String getIdentifier() throws IOException {
        try {
            File artifactFile = this.fileSupplier.get();
            HashCode hashCode = Hashing.murmur3_128().hashString((CharSequence)artifactFile.getAbsolutePath(), StandardCharsets.UTF_8);
            return "bin-" + BaseEncoding.base16().encode(hashCode.asBytes());
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private File loadArtifact() {
        try {
            String version;
            File file;
            Object artifactId = String.format(ZONKY_ARTIFACT_ID_TEMPLATE, this.os, ZonkyIOPostgresLocator.computeJarArchitectureName());
            if (EmbeddedUtil.IS_ALPINE_LINUX) {
                artifactId = (String)artifactId + "-alpine";
            }
            Preconditions.checkState(((file = this.artifactLoader.getArtifactFile(ZONKY_GROUP_ID, (String)artifactId, version = this.artifactLoader.findLatestVersion(ZONKY_GROUP_ID, (String)artifactId, this.serverVersion))) != null && file.exists() ? 1 : 0) != 0, (String)"Could not locate artifact file for %s:%s", (Object)artifactId, (Object)version);
            LOG.info(String.format("Using PostgreSQL version %s", version));
            return file;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private InputStream createJarStream(File file) {
        try {
            JarEntry jarEntry;
            final JarFile jar = new JarFile(file);
            Object entryName = String.format("postgres-%s-%s", ZonkyIOPostgresLocator.computeOS(), ZonkyIOPostgresLocator.computeTarXzArchitectureName());
            if (EmbeddedUtil.IS_ALPINE_LINUX) {
                entryName = (String)entryName + "-alpine_linux";
            }
            Preconditions.checkState(((jarEntry = jar.getJarEntry((String)entryName + ".txz")) != null ? 1 : 0) != 0, (String)"Could not locate %s in the jar file (%s)", (Object)entryName, (Object)file.getAbsoluteFile());
            return new FilterInputStream(jar.getInputStream(jarEntry)){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        jar.close();
                    }
                }
            };
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return String.format("ZonkyIO Stream locator for PostgreSQL (arch: %s os: %s, version: %s)", this.architecture, this.os, this.serverVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZonkyIOPostgresLocator that = (ZonkyIOPostgresLocator)o;
        return this.architecture.equals(that.architecture) && this.os.equals(that.os) && this.serverVersion.equals(that.serverVersion);
    }

    public int hashCode() {
        return Objects.hash(this.architecture, this.os, this.serverVersion);
    }

    private static String computeTarXzArchitectureName() {
        String architecture = EmbeddedUtil.OS_ARCH;
        if (EmbeddedUtil.IS_ARCH_X86_64) {
            architecture = "x86_64";
        } else if (EmbeddedUtil.IS_ARCH_AARCH64) {
            architecture = !PREFER_NATIVE && EmbeddedUtil.IS_OS_MAC ? "x86_64" : "arm_64";
        } else if (EmbeddedUtil.IS_ARCH_AARCH32) {
            architecture = "arm_32";
        }
        return architecture;
    }

    private static String computeJarArchitectureName() {
        String architecture = EmbeddedUtil.OS_ARCH;
        if (EmbeddedUtil.IS_ARCH_X86_64) {
            architecture = "amd64";
        } else if (EmbeddedUtil.IS_ARCH_AARCH64) {
            architecture = !PREFER_NATIVE && EmbeddedUtil.IS_OS_MAC ? "amd64" : "arm64v8";
        } else if (EmbeddedUtil.IS_ARCH_AARCH32) {
            architecture = "arm32v7";
        }
        return architecture;
    }

    private static String computeOS() {
        String os = EmbeddedUtil.OS_NAME;
        if (EmbeddedUtil.IS_OS_LINUX) {
            os = "linux";
        } else if (EmbeddedUtil.IS_OS_MAC) {
            os = "darwin";
        } else if (EmbeddedUtil.IS_OS_WINDOWS) {
            os = "windows";
        }
        return os;
    }
}

