/*
 * Decompiled with CFR 0.152.
 */
package de.softwareforge.testing.postgres.junit5;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import de.softwareforge.testing.postgres.embedded.DatabaseInfo;
import de.softwareforge.testing.postgres.embedded.DatabaseManager;
import de.softwareforge.testing.postgres.embedded.EmbeddedPostgres;
import de.softwareforge.testing.postgres.embedded.EmbeddedPostgresPreparer;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.sql.SQLException;
import java.util.Set;
import java.util.UUID;
import javax.sql.DataSource;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmbeddedPgExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedPgExtension.class);
    private final ExtensionContext.Namespace PG_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{UUID.randomUUID()});
    private final DatabaseManager.Builder<DatabaseManager> databaseManagerBuilder;
    private volatile DatabaseManager databaseManager = null;

    private EmbeddedPgExtension(DatabaseManager.Builder<DatabaseManager> databaseManagerBuilder) {
        this.databaseManagerBuilder = databaseManagerBuilder;
    }

    @NonNull
    static EmbeddedPgExtensionBuilder multiDatabase() {
        return new EmbeddedPgExtensionBuilder(true);
    }

    @NonNull
    static EmbeddedPgExtensionBuilder singleDatabase() {
        return new EmbeddedPgExtensionBuilder(false);
    }

    public EmbeddedPgExtension() {
        this(new DatabaseManager.DatabaseManagerBuilder(true).withInstancePreparer(EmbeddedPostgres.Builder::withDefaults));
    }

    @NonNull
    public DataSource createDataSource() throws SQLException {
        return this.createDatabaseInfo().asDataSource();
    }

    @VisibleForTesting
    EmbeddedPostgres getEmbeddedPostgres() {
        return this.databaseManager.getEmbeddedPostgres();
    }

    @NonNull
    public DatabaseInfo createDatabaseInfo() throws SQLException {
        Preconditions.checkState((this.databaseManager != null ? 1 : 0) != 0, (Object)"no before method has been called!");
        DatabaseInfo databaseInfo = this.databaseManager.getDatabaseInfo();
        LOG.info("Connection to {}", (Object)databaseInfo.asJdbcUrl());
        return databaseInfo;
    }

    public void beforeAll(@NonNull ExtensionContext extensionContext) throws Exception {
        Preconditions.checkNotNull((Object)extensionContext, (Object)"extensionContext is null");
        ExtensionContext.Store pgStore = extensionContext.getStore(this.PG_NAMESPACE);
        TestMode testMode = (TestMode)pgStore.getOrComputeIfAbsent(TestMode.TESTMODE_KEY, k -> new TestMode(extensionContext.getUniqueId(), this.databaseManagerBuilder.build()), TestMode.class);
        this.databaseManager = testMode.start(extensionContext.getUniqueId());
    }

    public void afterAll(@NonNull ExtensionContext extensionContext) throws Exception {
        Preconditions.checkNotNull((Object)extensionContext, (Object)"extensionContext is null");
        ExtensionContext.Store pgStore = extensionContext.getStore(this.PG_NAMESPACE);
        TestMode testMode = (TestMode)pgStore.get(TestMode.TESTMODE_KEY, TestMode.class);
        if (testMode != null) {
            this.databaseManager = testMode.stop(extensionContext.getUniqueId());
        }
    }

    public void beforeEach(@NonNull ExtensionContext extensionContext) throws Exception {
        Preconditions.checkNotNull((Object)extensionContext, (Object)"extensionContext is null");
        ExtensionContext.Store pgStore = extensionContext.getStore(this.PG_NAMESPACE);
        TestMode testMode = (TestMode)pgStore.getOrComputeIfAbsent(TestMode.TESTMODE_KEY, k -> new TestMode(extensionContext.getUniqueId(), this.databaseManagerBuilder.build()), TestMode.class);
        this.databaseManager = testMode.start(extensionContext.getUniqueId());
    }

    public void afterEach(@NonNull ExtensionContext extensionContext) throws Exception {
        Preconditions.checkNotNull((Object)extensionContext, (Object)"extensionContext is null");
        ExtensionContext.Store pgStore = extensionContext.getStore(this.PG_NAMESPACE);
        TestMode testMode = (TestMode)pgStore.get(TestMode.TESTMODE_KEY, TestMode.class);
        if (testMode != null) {
            this.databaseManager = testMode.stop(extensionContext.getUniqueId());
        }
    }

    public boolean supportsParameter(@NonNull ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> type = parameterContext.getParameter().getType();
        return type == EmbeddedPostgres.class || type == DatabaseInfo.class || type == DataSource.class;
    }

    public Object resolveParameter(@NonNull ParameterContext parameterContext, ExtensionContext extensionContext) {
        Class<?> type = parameterContext.getParameter().getType();
        try {
            if (type == EmbeddedPostgres.class) {
                return this.getEmbeddedPostgres();
            }
            if (type == DatabaseInfo.class) {
                return this.createDatabaseInfo();
            }
            if (type == DataSource.class) {
                return this.createDataSource();
            }
        }
        catch (SQLException e) {
            throw new ParameterResolutionException("Could not create " + type.getTypeName() + " instance", (Throwable)e);
        }
        return null;
    }

    public static final class EmbeddedPgExtensionBuilder
    extends DatabaseManager.Builder<EmbeddedPgExtension> {
        private EmbeddedPgExtensionBuilder(boolean multiMode) {
            super(multiMode);
        }

        @Override
        @NonNull
        public EmbeddedPgExtension build() {
            DatabaseManager.Builder<DatabaseManager> databaseManagerBuilder = new DatabaseManager.DatabaseManagerBuilder(this.multiMode).withDatabasePreparers((Set<EmbeddedPostgresPreparer<DataSource>>)this.databasePreparers.build()).withInstancePreparers((Set<EmbeddedPostgresPreparer<EmbeddedPostgres.Builder>>)this.instancePreparers.build());
            return new EmbeddedPgExtension(databaseManagerBuilder);
        }
    }

    private static final class TestMode {
        private static final Object TESTMODE_KEY = new Object();
        private final String id;
        private final DatabaseManager databaseManager;

        private TestMode(String id, DatabaseManager databaseManager) {
            this.id = id;
            this.databaseManager = databaseManager;
        }

        private DatabaseManager start(String id) throws Exception {
            if (this.id.equals(id)) {
                this.databaseManager.start();
            }
            return this.databaseManager;
        }

        private DatabaseManager stop(String id) throws Exception {
            if (this.id.equals(id)) {
                this.databaseManager.close();
                return null;
            }
            return this.databaseManager;
        }
    }
}

