/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.spi.ToolProvider;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Bartholdy {
    private static final System.Logger LOG = System.getLogger(Bartholdy.class.getName());

    public static void main(String[] args) {
        System.out.println("Bartholdy " + Bartholdy.version());
    }

    public static Path currentJdkHome() {
        Path executable = ProcessHandle.current().info().command().map(x$0 -> Path.of(x$0, new String[0])).orElseThrow();
        return executable.getParent().getParent().toAbsolutePath();
    }

    static String fileName(URI uri) {
        String urlString = uri.getPath();
        int begin = urlString.lastIndexOf(47) + 1;
        return urlString.substring(begin).split("\\?")[0].split("#")[0];
    }

    public static Path download(URI uri, Path tools) {
        return Bartholdy.download(uri, Bartholdy.fileName(uri), tools);
    }

    public static Path download(URI uri, String fileName, Path tools) {
        Path localPath = tools.resolve(fileName);
        if (Files.exists(localPath, new LinkOption[0])) {
            return localPath;
        }
        try {
            ReadableByteChannel rbc = Channels.newChannel(uri.toURL().openStream());
            Files.createDirectories(tools, new FileAttribute[0]);
            FileOutputStream fos = new FileOutputStream(localPath.toFile());
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            return localPath;
        }
        catch (IOException e) {
            throw new UncheckedIOException("download failed", e);
        }
    }

    public static Path install(URI uri, Path tools) {
        return Bartholdy.install(uri, Bartholdy.fileName(uri), tools);
    }

    public static Path install(URI uri, String zip, Path tools) {
        Path localZip = Bartholdy.download(uri, zip, tools);
        try {
            ToolProvider jarTool = ToolProvider.findFirst("jar").orElseThrow();
            StringWriter listing = new StringWriter();
            PrintWriter printWriter = new PrintWriter(listing);
            jarTool.run(printWriter, printWriter, "--list", "--file", localZip.toString());
            Path root = Path.of(listing.toString().split("\\R")[0], new String[0]);
            Path home = tools.resolve(root);
            if (Files.notExists(home, new LinkOption[0])) {
                jarTool.run(System.out, System.err, "--extract", "--file", localZip.toString());
                Files.move(root, home, new CopyOption[0]);
            }
            return home.normalize().toAbsolutePath();
        }
        catch (IOException e) {
            throw new UncheckedIOException("install failed", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String read(Path jar, String entry, String delimiter, String defaultValue) {
        try (FileSystem fs = FileSystems.newFileSystem(jar, null);){
            Path root;
            Path versionPath;
            Iterator<Path> iterator = fs.getRootDirectories().iterator();
            do {
                if (!iterator.hasNext()) return defaultValue;
            } while (!Files.exists(versionPath = (root = iterator.next()).resolve(entry), new LinkOption[0]));
            String string = String.join((CharSequence)delimiter, Files.readAllLines(versionPath));
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException("read entry failed", e);
        }
    }

    public static String readProperty(String source, String key, String defaultValue) {
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(source));
        }
        catch (IOException e) {
            throw new UncheckedIOException("read property failed", e);
        }
        return properties.getProperty(key, defaultValue);
    }

    public static Path setExecutable(Path path) {
        if (Files.isExecutable(path)) {
            return path;
        }
        if (!FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
            LOG.log(System.Logger.Level.DEBUG, "default file system doesn't support posix");
            return path;
        }
        File program = path.toFile();
        boolean ok = program.setExecutable(true);
        if (!ok) {
            LOG.log(System.Logger.Level.WARNING, "couldn't set executable flag: " + program);
        }
        return path;
    }

    public static void treeCopy(Path source, Path target) {
        Bartholdy.treeCopy(source, target, __ -> true);
    }

    public static void treeCopy(Path source, Path target, Predicate<Path> filter) {
        LOG.log(System.Logger.Level.DEBUG, "treeCopy(source:`{0}`, target:`{1}`)", source, target);
        if (!Files.exists(source, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(source, new LinkOption[0])) {
            throw new IllegalArgumentException("source must be a directory: " + source);
        }
        if (Files.exists(target, new LinkOption[0])) {
            if (!Files.isDirectory(target, new LinkOption[0])) {
                throw new IllegalArgumentException("target must be a directory: " + target);
            }
            try {
                if (Files.isSameFile(source, target)) {
                    return;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("copyTree failed", e);
            }
        }
        try (Stream<Path> stream = Files.walk(source, new FileVisitOption[0]).sorted();){
            int counter = 0;
            List paths = stream.collect(Collectors.toList());
            for (Path path : paths) {
                Path destination = target.resolve(source.relativize(path));
                if (Files.isDirectory(path, new LinkOption[0])) {
                    Files.createDirectories(destination, new FileAttribute[0]);
                    continue;
                }
                if (!filter.test(path)) continue;
                Files.copy(path, destination, StandardCopyOption.REPLACE_EXISTING);
                ++counter;
            }
            LOG.log(System.Logger.Level.DEBUG, "copied {0} file(s) of {1} elements...%n", counter, paths.size());
        }
        catch (IOException e) {
            throw new UncheckedIOException("copyTree failed", e);
        }
    }

    public static void treeDelete(Path root) {
        Bartholdy.treeDelete(root, path -> true);
    }

    public static void treeDelete(Path root, Predicate<Path> filter) {
        try {
            if (Files.deleteIfExists(root)) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);){
            Stream<Path> selected = stream.filter(filter).sorted((p, q) -> -p.compareTo((Path)q));
            for (Path path : selected.collect(Collectors.toList())) {
                Files.deleteIfExists(path);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("removing tree failed: " + root, e);
        }
    }

    public static void treeList(Path root, Consumer<String> out) {
        if (Files.exists(root, new LinkOption[0])) {
            out.accept(root.toString());
        }
        try (Stream<Path> stream = Files.walk(root, new FileVisitOption[0]).sorted();){
            for (Path path : stream.collect(Collectors.toList())) {
                String string = root.relativize(path).toString();
                String prefix = string.isEmpty() ? "" : File.separator;
                out.accept("." + prefix + string);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("dumping tree failed: " + root, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String version() {
        ClassLoader loader = Bartholdy.class.getClassLoader();
        try (InputStream is = loader.getResourceAsStream("de/sormuras/bartholdy/version.properties");){
            if (is == null) {
                String string2 = "DEVELOPMENT";
                return string2;
            }
            Properties properties = new Properties();
            properties.load(is);
            String string = properties.getProperty("version", "UNKNOWN");
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException("read version failed", e);
        }
    }

    private Bartholdy() {
        throw new UnsupportedOperationException();
    }
}

