/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface Result {
    public static Builder builder() {
        return new Builder();
    }

    public int getExitCode();

    public Duration getDuration();

    default public String getOutput(String key) {
        return String.join((CharSequence)"\n", this.getOutputLines(key));
    }

    public List<String> getOutputLines(String var1);

    public boolean isTimedOut();

    public static class Builder
    implements Result {
        private int exitCode = Integer.MIN_VALUE;
        private Duration duration = Duration.ZERO;
        private Map<String, List<String>> lines = new HashMap<String, List<String>>();
        private boolean timedOut;

        public Result build() {
            Objects.requireNonNull(this.duration, "duration must not be null");
            return this;
        }

        public String toString() {
            return "Result{exitCode=" + this.exitCode + ", timedOut=" + this.timedOut + ", duration=" + this.duration + ", lines=" + this.lines + "}";
        }

        @Override
        public int getExitCode() {
            return this.exitCode;
        }

        public Builder setExitCode(int exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        @Override
        public Duration getDuration() {
            return this.duration;
        }

        public Builder setDuration(Duration duration) {
            this.duration = duration;
            return this;
        }

        public Builder setOutput(String key, String output) {
            return this.setOutput(key, List.of(output.split("\\R")));
        }

        public Builder setOutput(String key, List<String> output) {
            this.lines.put(key, output);
            return this;
        }

        @Override
        public List<String> getOutputLines(String key) {
            return this.lines.getOrDefault(key, List.of());
        }

        @Override
        public boolean isTimedOut() {
            return this.timedOut;
        }

        public Builder setTimedOut(boolean timedOut) {
            this.timedOut = timedOut;
            return this;
        }
    }
}

