/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy.tool;

import de.sormuras.bartholdy.Bartholdy;
import de.sormuras.bartholdy.Configuration;
import de.sormuras.bartholdy.Result;
import de.sormuras.bartholdy.Tool;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class AbstractTool
implements Tool {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result run(Configuration configuration) {
        long timeout = configuration.getTimeout().toMillis();
        List<String> command = this.createCommand(configuration);
        ProcessBuilder builder = new ProcessBuilder(command);
        Path working = configuration.getWorkingDirectory();
        builder.directory(working.toFile());
        builder.environment().put("JAVA_HOME", Bartholdy.currentJdkHome().toString());
        builder.environment().put(this.getNameOfEnvironmentHomeVariable(), this.getHome().toString());
        builder.environment().putAll(configuration.getEnvironment());
        try {
            Instant start = Instant.now();
            String timestamp = start.toString().replace(':', '-');
            Path errfile = working.resolve(".bartholdy-err-" + timestamp + ".txt");
            Path outfile = working.resolve(".bartholdy-out-" + timestamp + ".txt");
            builder.redirectError(errfile.toFile());
            builder.redirectOutput(outfile.toFile());
            Process process = builder.start();
            try {
                boolean timedOut = false;
                if (!process.waitFor(timeout, TimeUnit.MILLISECONDS)) {
                    int i;
                    timedOut = true;
                    process.destroy();
                    for (i = 10; i > 0 && process.isAlive(); --i) {
                        Thread.sleep(123L);
                    }
                    if (process.isAlive()) {
                        process.destroyForcibly();
                        for (i = 10; i > 0 && process.isAlive(); --i) {
                            Thread.sleep(1234L);
                        }
                    }
                }
                if (process.isAlive()) {
                    throw new RuntimeException("process is still alive: " + process.info());
                }
                Duration duration = Duration.between(start, Instant.now());
                Result result = Result.builder().setTimedOut(timedOut).setExitCode(process.exitValue()).setDuration(duration).setOutput("err", AbstractTool.readAllLines(errfile)).setOutput("out", AbstractTool.readAllLines(outfile)).build();
                return result;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("run failed", e);
            }
            finally {
                Files.deleteIfExists(errfile);
                Files.deleteIfExists(outfile);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("starting process failed", e);
        }
    }

    private List<String> createCommand(Configuration configuration) {
        String program = this.createProgram(this.createPathToProgram());
        ArrayList<String> command = new ArrayList<String>();
        command.add(program);
        command.addAll(this.getToolArguments());
        command.addAll(configuration.getArguments());
        int commandLineLength = String.join((CharSequence)" ", command).length();
        if (commandLineLength < 32000) {
            return command;
        }
        String timestamp = Instant.now().toString().replace("-", "").replace(":", "");
        String prefix = "bartholdy-" + this.getName() + "-arguments-" + timestamp + "-";
        try {
            Path temporaryDirectory = configuration.getTemporaryDirectory();
            Path temporaryFile = Files.createTempFile(temporaryDirectory, prefix, ".txt", new FileAttribute[0]);
            return List.of(program, "@" + Files.write(temporaryFile, configuration.getArguments(), new OpenOption[0]));
        }
        catch (IOException e) {
            throw new UncheckedIOException("creating temporary arguments file failed", e);
        }
    }

    public Path getHome() {
        return Path.of(".", new String[0]);
    }

    public String getNameOfEnvironmentHomeVariable() {
        return this.getClass().getSimpleName().toUpperCase() + "_HOME";
    }

    protected Path createPathToProgram() {
        return this.getHome().resolve("bin").resolve(this.getProgram());
    }

    protected String createProgram(Path pathToProgram) {
        return pathToProgram.normalize().toAbsolutePath().toString();
    }

    protected List<String> getToolArguments() {
        return List.of();
    }

    private static List<String> readAllLines(Path path) {
        try {
            return Files.readAllLines(path);
        }
        catch (IOException iOException) {
            ArrayList<String> lines = new ArrayList<String>();
            try (BufferedReader br = new BufferedReader(new FileReader(path.toFile()));){
                String line;
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("reading lines failed: " + path, e);
            }
            return lines;
        }
    }
}

