/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bartholdy.tool;

import de.sormuras.bartholdy.Configuration;
import de.sormuras.bartholdy.Result;
import de.sormuras.bartholdy.Tool;
import de.sormuras.bartholdy.jdk.Jdeps;
import de.sormuras.bartholdy.util.CycleDetectedException;
import de.sormuras.bartholdy.util.DirectedAcyclicGraph;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public class CyclesDetector
implements Tool {
    private final Path path;
    private final BiPredicate<String, String> exclude;

    public CyclesDetector(Path path) {
        this(path, String::equals);
    }

    public CyclesDetector(Path path, BiPredicate<String, String> exclude) {
        this.path = path;
        this.exclude = exclude;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getVersion() {
        return "1.2";
    }

    @Override
    public Result run(Configuration configuration) {
        Result.Builder result = Result.builder();
        try {
            this.detectCycles(result, this.path);
            result.setExitCode(result.getOutputLines("cycles").isEmpty() ? 0 : 1);
        }
        catch (Exception e) {
            result.setExitCode(-1);
            result.setOutput("out", e.toString());
            result.setOutput("err", Arrays.stream(e.getStackTrace()).map(Object::toString).collect(Collectors.toList()));
        }
        return result.build();
    }

    private void detectCycles(Result.Builder result, Path path) {
        Configuration.Builder dependenciesConfiguration = Configuration.builder();
        try (JarFile jar = new JarFile(path.toFile());){
            if (jar.isMultiRelease()) {
                int version = Runtime.version().feature();
                dependenciesConfiguration.addArgument("--multi-release").addArgument(version);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Opening jar failed: " + e);
        }
        dependenciesConfiguration.addArgument("-verbose:class");
        dependenciesConfiguration.addArgument(path);
        Result dependencies = new Jdeps().run(dependenciesConfiguration.build());
        if (dependencies.getExitCode() != 0) {
            throw new RuntimeException("Running jdeps failed: " + dependencies);
        }
        List lines = dependencies.getOutputLines("out").stream().filter(line -> line.startsWith("   ")).filter(line -> line.contains("->")).map(String::trim).collect(Collectors.toList());
        if (lines.isEmpty()) {
            return;
        }
        ArrayList<Item> items = new ArrayList<Item>();
        for (String line2 : lines) {
            Item item = new Item(line2);
            if (this.exclude.test(item.sourcePackage, item.targetPackage)) continue;
            items.add(item);
        }
        if (items.isEmpty()) {
            return;
        }
        DirectedAcyclicGraph graph = new DirectedAcyclicGraph();
        ArrayList<String> cycles = new ArrayList<String>();
        ArrayList<String> edges = new ArrayList<String>();
        for (Item item : items) {
            try {
                if (!graph.addEdge(item.sourcePackage, item.targetPackage)) continue;
                edges.add(item.sourcePackage + " -> " + item.targetPackage);
            }
            catch (CycleDetectedException exception) {
                cycles.add(String.format("Adding edge '%s' failed. %s", item, exception.getMessage()));
            }
        }
        result.setOutput("items", items.stream().map(Object::toString).collect(Collectors.toList()));
        result.setOutput("edges", edges);
        result.setOutput("cycles", cycles);
    }

    private static String classNameOf(String raw) {
        raw = raw.trim();
        int indexOfSlash = (raw = raw.replaceAll("\"", "")).indexOf(47);
        if (indexOfSlash >= 0) {
            raw = raw.substring(indexOfSlash + 1);
        }
        return raw;
    }

    private static String packageNameOf(String className) {
        int indexOfLastDot = className.lastIndexOf(46);
        if (indexOfLastDot < 0) {
            return "";
        }
        return className.substring(0, indexOfLastDot);
    }

    private static class Item {
        private final String sourceClass;
        private final String targetClass;
        private final String sourcePackage;
        private final String targetPackage;

        Item(String line) {
            String[] split = line.split("->");
            String target = split[1].trim();
            this.sourceClass = CyclesDetector.classNameOf(split[0].trim());
            this.targetClass = CyclesDetector.classNameOf(target.substring(0, target.indexOf(32)));
            this.sourcePackage = CyclesDetector.packageNameOf(this.sourceClass);
            this.targetPackage = CyclesDetector.packageNameOf(this.targetClass);
        }

        public String toString() {
            return this.sourceClass + " -> " + this.targetClass;
        }
    }
}

