/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.javacompilerscriptengine;

import de.sormuras.javacompilerscriptengine.JavaCompilerScriptEngine;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

public class JavaCompilerScriptEngineFactory
implements ScriptEngineFactory {
    @Override
    public String getEngineName() {
        return (String)this.getParameter("javax.script.engine");
    }

    @Override
    public String getEngineVersion() {
        return (String)this.getParameter("javax.script.engine_version");
    }

    @Override
    public List<String> getExtensions() {
        return Collections.singletonList("java");
    }

    @Override
    public List<String> getMimeTypes() {
        return Collections.singletonList("text/java");
    }

    @Override
    public List<String> getNames() {
        return Collections.singletonList("java");
    }

    @Override
    public String getLanguageName() {
        return (String)this.getParameter("javax.script.language");
    }

    @Override
    public String getLanguageVersion() {
        return (String)this.getParameter("javax.script.language_version");
    }

    @Override
    public Object getParameter(String string) {
        switch (string) {
            case "javax.script.name": {
                return "Giacomo";
            }
            case "javax.script.engine": {
                return "Java Compiler Script Engine";
            }
            case "javax.script.engine_version": {
                return this.getClass().getModule().getDescriptor().version().map(Object::toString).orElse("?");
            }
            case "javax.script.language": {
                return "Java";
            }
            case "javax.script.language_version": {
                return System.getProperty("java.version");
            }
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String string, String string2, String ... stringArray) {
        return string + "." + string2 + "(" + String.join((CharSequence)", ", stringArray) + ")";
    }

    @Override
    public String getOutputStatement(String string) {
        return "System.out.println(\"" + string + "\")";
    }

    @Override
    public String getProgram(String ... stringArray) {
        String string = ";\n";
        return String.join((CharSequence)string, stringArray) + string;
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new JavaCompilerScriptEngine(this);
    }
}

