/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.javacompilerscriptengine;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.SecureClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Processor;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

final class JavaCompilerUtils {
    JavaCompilerUtils() {
    }

    static Class<?> compile(String string, String string2) {
        ClassLoader classLoader = JavaCompilerUtils.compile(JavaCompilerUtils.source(string.replace('.', '/') + ".java", string2));
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Class or interface '" + string + "' not found?!", classNotFoundException);
        }
    }

    static ClassLoader compile(JavaFileObject ... javaFileObjectArray) {
        return JavaCompilerUtils.compile(null, Collections.emptyList(), Collections.emptyList(), Arrays.asList(javaFileObjectArray));
    }

    static ClassLoader compile(ClassLoader classLoader, List<String> list, List<Processor> list2, List<JavaFileObject> list3) {
        boolean bl;
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        Objects.requireNonNull(javaCompiler, "No system java compiler available - JDK is required!");
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(diagnosticCollector, Locale.getDefault(), StandardCharsets.UTF_8);
        Manager manager = new Manager(standardJavaFileManager, classLoader);
        JavaCompiler.CompilationTask compilationTask = javaCompiler.getTask(null, manager, diagnosticCollector, list, null, list3);
        if (!list2.isEmpty()) {
            compilationTask.setProcessors(list2);
        }
        if (!(bl = compilationTask.call().booleanValue())) {
            throw new RuntimeException("Compilation failed! " + diagnosticCollector.getDiagnostics());
        }
        return manager.getClassLoader(StandardLocation.CLASS_PATH);
    }

    static JavaFileObject source(String string, String string2) {
        return JavaCompilerUtils.source(URI.create(string), string2);
    }

    static JavaFileObject source(URI uRI, String string) {
        return new CharContentFileObject(uRI, string);
    }

    static class SecureLoader
    extends SecureClassLoader {
        private final Map<String, ByteArrayFileObject> map;

        SecureLoader(ClassLoader classLoader, Map<String, ByteArrayFileObject> map) {
            super(classLoader);
            this.map = map;
        }

        @Override
        protected Class<?> findClass(String string) throws ClassNotFoundException {
            ByteArrayFileObject byteArrayFileObject = this.map.get(string);
            if (byteArrayFileObject == null) {
                throw new ClassNotFoundException(string);
            }
            byte[] byArray = byteArrayFileObject.getBytes();
            return super.defineClass(string, byArray, 0, byArray.length);
        }
    }

    static class Manager
    extends ForwardingJavaFileManager<StandardJavaFileManager> {
        private final Map<String, ByteArrayFileObject> map = new HashMap<String, ByteArrayFileObject>();
        private final ClassLoader parent;

        Manager(StandardJavaFileManager standardJavaFileManager, ClassLoader classLoader) {
            super(standardJavaFileManager);
            this.parent = classLoader != null ? classLoader : this.getClass().getClassLoader();
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return new SecureLoader(this.parent, this.map);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) {
            switch (kind) {
                case CLASS: {
                    ByteArrayFileObject byteArrayFileObject = new ByteArrayFileObject(string, kind);
                    this.map.put(string, byteArrayFileObject);
                    return byteArrayFileObject;
                }
                case SOURCE: {
                    return new SourceFileObject(string, kind);
                }
            }
            throw new UnsupportedOperationException("kind not supported: " + kind);
        }

        @Override
        public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
            return fileObject.toUri().equals(fileObject2.toUri());
        }
    }

    static class SourceFileObject
    extends SimpleJavaFileObject {
        private ByteArrayOutputStream stream;

        SourceFileObject(String string, JavaFileObject.Kind kind) {
            super(URI.create("giacomo:///" + string.replace('.', '/') + kind.extension), kind);
        }

        @Override
        public String getCharContent(boolean bl) {
            try {
                return this.stream.toString(StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (bl) {
                    return this.stream.toString();
                }
                throw new UnsupportedOperationException(unsupportedEncodingException);
            }
        }

        @Override
        public OutputStream openOutputStream() {
            this.stream = new ByteArrayOutputStream(2000);
            return this.stream;
        }
    }

    static class CharContentFileObject
    extends SimpleJavaFileObject {
        private final String charContent;
        private final long lastModified;

        CharContentFileObject(String string, String string2) {
            this(URI.create(string), string2);
        }

        CharContentFileObject(URI uRI, String string) {
            super(uRI, JavaFileObject.Kind.SOURCE);
            this.charContent = string;
            this.lastModified = System.currentTimeMillis();
        }

        @Override
        public String getCharContent(boolean bl) {
            return this.charContent;
        }

        @Override
        public long getLastModified() {
            return this.lastModified;
        }
    }

    static class ByteArrayFileObject
    extends SimpleJavaFileObject {
        private ByteArrayOutputStream stream;

        ByteArrayFileObject(String string, JavaFileObject.Kind kind) {
            super(URI.create("giacomo:///" + string.replace('.', '/') + kind.extension), kind);
        }

        byte[] getBytes() {
            return this.stream.toByteArray();
        }

        @Override
        public OutputStream openOutputStream() {
            this.stream = new ByteArrayOutputStream(2000);
            return this.stream;
        }
    }
}

