/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.isolator.Configuration;
import de.sormuras.junit.platform.isolator.ConfigurationBuilder;
import de.sormuras.junit.platform.isolator.Driver;
import de.sormuras.junit.platform.isolator.Isolator;
import de.sormuras.junit.platform.isolator.Modules;
import de.sormuras.junit.platform.isolator.OverlaySingleton;
import de.sormuras.junit.platform.isolator.TestMode;
import de.sormuras.junit.platform.isolator.Version;
import de.sormuras.junit.platform.maven.plugin.Executor;
import de.sormuras.junit.platform.maven.plugin.Isolation;
import de.sormuras.junit.platform.maven.plugin.JavaExecutor;
import de.sormuras.junit.platform.maven.plugin.JavaOptions;
import de.sormuras.junit.platform.maven.plugin.MavenDriver;
import de.sormuras.junit.platform.maven.plugin.MojoHelper;
import de.sormuras.junit.platform.maven.plugin.Selectors;
import de.sormuras.junit.platform.maven.plugin.SurefireMigrationSupport;
import de.sormuras.junit.platform.maven.plugin.Tweaks;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;

@Component(role=AbstractMavenLifecycleParticipant.class)
@org.apache.maven.plugins.annotations.Mojo(name="launch", defaultPhase=LifecyclePhase.TEST, threadSafe=true, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class JUnitPlatformMojo
extends AbstractMavenLifecycleParticipant
implements Mojo {
    @Parameter(defaultValue="false", property="junit-platform.skip")
    private boolean skip = false;
    @Parameter(defaultValue="NONE")
    private Isolation isolation = Isolation.NONE;
    @Parameter(defaultValue="false")
    private boolean dryRun = false;
    @Parameter(defaultValue="300")
    private long timeout = 300L;
    @Parameter(defaultValue="DIRECT")
    private Executor executor = Executor.DIRECT;
    @Parameter
    private JavaOptions javaOptions = new JavaOptions();
    @Parameter
    private Tweaks tweaks = new Tweaks();
    @Parameter
    private Selectors selectors = new Selectors();
    @Parameter
    private Map<String, String> versions = Collections.emptyMap();
    @Parameter(defaultValue="${project.build}", readonly=true, required=true)
    private Build mavenBuild;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject mavenProject;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession mavenRepositorySession;
    @org.apache.maven.plugins.annotations.Component
    private RepositorySystem mavenResolver;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @org.apache.maven.plugins.annotations.Component
    private ToolchainManager mavenToolchainManager;
    @Parameter
    private Map<String, String> parameters = Collections.emptyMap();
    @Parameter
    private Set<String> classNamePatterns;
    @Parameter(property="test")
    private String test;
    @Parameter(property="tag")
    private Set<String> tags = Collections.emptySet();
    @Parameter(defaultValue="${project.build.directory}/junit-platform")
    private File targetDirectory;
    @Parameter(readonly=true, defaultValue="${mojoExecution}")
    private MojoExecution execution;
    private Log log;
    private Modules projectModules;
    private Map<String, String> projectVersions;

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        if (this.log == null) {
            this.log = new SystemStreamLog();
        }
        return this.log;
    }

    void debug(String format, Object ... args) {
        this.getLog().debug((CharSequence)JUnitPlatformMojo.formatMessage(format, args));
    }

    private void debug(String caption, Collection<String> paths) {
        this.debug(caption, new Object[0]);
        paths.forEach(path -> this.debug(String.format("  %-50s -> %s", Paths.get(path, new String[0]).getFileName(), path), new Object[0]));
    }

    private void debug(String key, Artifact artifact) {
        this.debug(String.format("  %-50s -> %s trail=%s", key, artifact, artifact.getDependencyTrail()), new Object[0]);
    }

    void info(String format, Object ... args) {
        this.getLog().info((CharSequence)JUnitPlatformMojo.formatMessage(format, args));
    }

    void warn(String format, Object ... args) {
        this.getLog().warn((CharSequence)JUnitPlatformMojo.formatMessage(format, args));
    }

    void error(String format, Object ... args) {
        this.getLog().error((CharSequence)JUnitPlatformMojo.formatMessage(format, args));
    }

    private static String formatMessage(String pattern, Object ... args) {
        if (args.length == 0) {
            return pattern;
        }
        try {
            return MessageFormat.format(pattern, args);
        }
        catch (IllegalArgumentException e) {
            return pattern + " " + Arrays.asList(args) + " // " + e.getClass() + ": " + e.getMessage();
        }
    }

    public void afterProjectsRead(MavenSession session) {
        String group = "de.sormuras.junit";
        String artifact = "junit-platform-maven-plugin";
        for (MavenProject project : session.getProjects()) {
            this.findPlugin(project, group, artifact).ifPresent(plugin -> this.injectThisPlugin(session, project, (Plugin)plugin));
        }
    }

    private void injectThisPlugin(MavenSession session, MavenProject project, Plugin thisPlugin) {
        PluginExecution execution = new PluginExecution();
        execution.setId("injected-launch");
        execution.getGoals().add("launch");
        execution.setPhase("test");
        execution.setConfiguration(thisPlugin.getConfiguration());
        thisPlugin.getExecutions().add(execution);
        String surefireGroup = "org.apache.maven.plugins";
        String surefireArtifact = "maven-surefire-plugin";
        this.findPlugin(project, surefireGroup, surefireArtifact).ifPresent(surefire -> this.mangleSurefirePlugin(session, (Plugin)surefire, thisPlugin));
    }

    private void mangleSurefirePlugin(MavenSession session, Plugin surefirePlugin, Plugin junitPlugin) {
        if (!Boolean.getBoolean("junit-platform.surefire.keep.executions")) {
            surefirePlugin.getExecutions().clear();
        }
        new SurefireMigrationSupport(this, session).apply(surefirePlugin, junitPlugin);
    }

    private Optional<Plugin> findPlugin(MavenProject project, String group, String artifact) {
        List plugins = project.getModel().getBuild().getPlugins();
        return plugins.stream().filter(plugin -> group.equals(plugin.getGroupId())).filter(plugin -> artifact.equals(plugin.getArtifactId())).reduce((u, v) -> {
            throw new IllegalStateException("Plugin is not unique: " + artifact);
        });
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.debug("Executing JUnitPlatformMojo...", new Object[0]);
        if (this.skip) {
            this.info("JUnit Platform Plugin execution skipped.", new Object[0]);
            return;
        }
        if (this.mavenProject.getPackaging().equals("pom")) {
            this.info("JUnit Platform Plugin execution skipped: project uses 'pom' packaging", new Object[0]);
            return;
        }
        MojoHelper mojoHelper = new MojoHelper(this, this.mavenSession, this.execution);
        mojoHelper.autoConfigure("javaOptions", this.javaOptions);
        mojoHelper.autoConfigure("tweaks", this.tweaks);
        Path mainPath = Paths.get(this.mavenBuild.getOutputDirectory(), new String[0]);
        Path testPath = Paths.get(this.mavenBuild.getTestOutputDirectory(), new String[0]);
        this.projectModules = new Modules(mainPath, testPath);
        this.projectVersions = Version.buildMap(this::artifactVersionOrNull);
        String moduleInfoTest = JUnitPlatformMojo.findModuleInfoTest(this.mavenBuild.getTestSourceDirectory(), testPath.toString());
        this.info("Launching JUnit Platform {0}...", this.version(Version.JUNIT_PLATFORM_VERSION));
        if (this.getLog().isDebugEnabled()) {
            this.debug("Path", new Object[0]);
            this.debug("  java.home = {0}", System.getProperty("java.home"));
            this.debug("  user.dir = {0}", System.getProperty("user.dir"));
            this.debug("  project.basedir = {0}", this.mavenProject.getBasedir());
            this.debug("Class Loader", new Object[0]);
            this.debug("  mojo''s loader = {0}", ((Object)((Object)this)).getClass().getClassLoader());
            this.debug("  context loader = {0}", Thread.currentThread().getContextClassLoader());
            this.debug("  platform loader = {0}", OverlaySingleton.INSTANCE.platformClassLoader());
            this.debug("Artifact Map", new Object[0]);
            this.mavenProject.getArtifactMap().keySet().stream().sorted().forEach(k -> this.debug((String)k, (Artifact)this.getMavenProject().getArtifactMap().get(k)));
            this.debug("Version", new Object[0]);
            this.debug("  java.version = {0}", System.getProperty("java.version"));
            this.debug("  java.class.version = {0}", System.getProperty("java.class.version"));
            Version.forEach(v -> this.debug("  {0} = {1}", v.getKey(), this.version((Version)v)));
            this.debug("Java Module System", new Object[0]);
            this.debug("  main -> {0}", this.projectModules.toStringMainModule());
            this.debug("  test -> {0}", this.projectModules.toStringTestModule());
            this.debug("  mode -> {0}", this.projectModules.getMode());
            this.debug("  module-info.test -> {0}", moduleInfoTest);
        }
        Path targetPath = this.targetDirectory.toPath();
        try {
            Files.createDirectories(targetPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't create target path: " + targetPath, (Exception)e);
        }
        MavenDriver driver = new MavenDriver(this);
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder().setDryRun(this.isDryRun()).setFailIfNoTests(this.tweaks.failIfNoTests).setDefaultAssertionStatus(this.tweaks.defaultAssertionStatus).setPlatformClassLoader(this.tweaks.platformClassLoader).setTargetDirectory(targetPath.toString()).setTargetMainPath(mainPath.toString()).setTargetTestPath(testPath.toString()).setWorkerIsolationRequired(this.tweaks.workerIsolationRequired).setPaths(driver.buildPathMap(targetPath)).setModuleInfoTestPath(moduleInfoTest).discovery().setSelectedDirectories(this.selectors.directories).setSelectedFiles(this.selectors.files).setSelectedModules(this.selectors.modules).setSelectedPackages(this.selectors.packages).setSelectedClasses(this.selectors.classes).setSelectedMethods(this.selectors.methods).setSelectedClasspathResources(this.selectors.resources).setSelectedUris(this.selectors.uris).setFilterClassNamePatterns(this.classNamePatterns).setFilterTags(this.tags).setParameters(this.parameters).end();
        if (this.selectors.isEmpty()) {
            TestMode mode;
            this.debug("No custom selector was configured, providing default one...", new Object[0]);
            if (Files.notExists(testPath, new LinkOption[0])) {
                if (this.tweaks.skipOnMissingTestOutputDirectory) {
                    this.info("JUnit Platform Plugin execution skipped: test output directory does not exist.", new Object[0]);
                    return;
                }
                this.warn("Test output directory does not exist... this may lead to failures", new Object[0]);
            }
            if ((mode = this.projectModules.getMode()) == TestMode.CLASSIC) {
                Set<String> roots = Collections.singleton(this.mavenBuild.getTestOutputDirectory());
                configurationBuilder.discovery().setSelectedClasspathRoots(roots);
            } else {
                String module = mode == TestMode.MODULAR_PATCHED_TEST_RUNTIME ? (String)this.projectModules.getMainModuleName().orElseThrow(AssertionError::new) : (String)this.projectModules.getTestModuleName().orElseThrow(AssertionError::new);
                Set<String> modules = Collections.singleton(module);
                configurationBuilder.discovery().setSelectedModules(modules);
            }
        }
        Configuration configuration = configurationBuilder.build();
        if (this.getLog().isDebugEnabled()) {
            this.debug("Isolator Path Layering", new Object[0]);
            configuration.basic().getPaths().forEach(this::debug);
        }
        try {
            int result = this.execute(driver, configuration);
            if (result == 2) {
                throw new MojoFailureException("No tests found.");
            }
            if (result != 0) {
                throw new MojoFailureException("RED ALERT!");
            }
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AssertionError("Unexpected exception caught!", e);
        }
    }

    private int execute(Driver driver, Configuration configuration) throws Exception {
        if (this.executor == Executor.DIRECT) {
            return this.executeDirect(driver, configuration);
        }
        if (this.executor == Executor.JAVA) {
            return this.executeJava(configuration);
        }
        throw new MojoExecutionException("Unsupported executor: " + (Object)((Object)this.executor));
    }

    private int executeDirect(Driver driver, Configuration configuration) throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Integer> future = executor.submit(() -> new Isolator(driver).evaluate(configuration));
        try {
            int n = future.get(this.timeout, TimeUnit.SECONDS);
            return n;
        }
        catch (TimeoutException e) {
            this.warn("Global timeout of {0} second(s) reached.", this.timeout);
            throw new MojoFailureException("Global timeout reached.", (Throwable)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Execution failed!", e);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private int executeJava(Configuration configuration) {
        JavaExecutor executor = new JavaExecutor(this);
        return executor.evaluate(configuration);
    }

    String getTest() {
        return this.test;
    }

    Executor getExecutor() {
        return this.executor;
    }

    JavaOptions getJavaOptions() {
        return this.javaOptions;
    }

    Tweaks getTweaks() {
        return this.tweaks;
    }

    Modules getProjectModules() {
        return this.projectModules;
    }

    MavenProject getMavenProject() {
        return this.mavenProject;
    }

    MavenSession getMavenSession() {
        return this.mavenSession;
    }

    public MojoExecution getMojoExecution() {
        return this.execution;
    }

    RepositorySystemSession getMavenRepositorySession() {
        return this.mavenRepositorySession;
    }

    RepositorySystem getMavenResolver() {
        return this.mavenResolver;
    }

    long getTimeout() {
        return this.timeout;
    }

    boolean isDryRun() {
        return this.dryRun;
    }

    Isolation getIsolation() {
        return this.isolation;
    }

    private String artifactVersionOrNull(String key) {
        Artifact artifact = (Artifact)this.mavenProject.getArtifactMap().get(key);
        if (artifact == null) {
            return null;
        }
        return artifact.getBaseVersion();
    }

    String version(Version version) {
        String detectedVersion = this.projectVersions.get(version.getKey());
        return this.versions.getOrDefault(version.getKey(), detectedVersion);
    }

    @SafeVarargs
    final void removeExcludedArtifacts(Collection<String> ... collections) {
        for (String exclude : this.tweaks.dependencyExcludes) {
            Artifact artifact = (Artifact)this.mavenProject.getArtifactMap().get(exclude);
            if (artifact == null) {
                this.debug("Can't exclude what isn't included: " + exclude, new Object[0]);
                continue;
            }
            String excludedPath = artifact.getFile().toPath().toString();
            for (Collection<String> collection : collections) {
                collection.remove(excludedPath);
            }
        }
    }

    String getJavaExecutable() {
        Path java = Paths.get(this.getJavaExecutable(this.javaOptions.executable), new String[0]).normalize().toAbsolutePath();
        if (!Files.isExecutable(java)) {
            this.warn("{0} is not executable", java);
        }
        return java.toString();
    }

    private String getJavaExecutable(String executable) {
        String java;
        if (executable != null && !executable.isEmpty()) {
            return executable;
        }
        Toolchain toolchain = this.mavenToolchainManager.getToolchainFromBuildContext("jdk", this.mavenSession);
        if (toolchain != null && (java = toolchain.findTool("java")) != null) {
            return java;
        }
        String extension = System.getProperty("os.name").toLowerCase().contains("win") ? ".exe" : "";
        Path home = Paths.get(System.getProperty("java.home"), new String[0]);
        Path java2 = home.resolve("bin").resolve("java" + extension);
        return java2.toString();
    }

    private static String findModuleInfoTest(String ... roots) {
        for (String root : roots) {
            Path candidate = Paths.get(root, new String[0]).resolve("module-info.test");
            if (!Files.isReadable(candidate)) continue;
            return candidate.toString();
        }
        return "";
    }
}

