/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.mainrunner.engine;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.engine.support.discovery.EngineDiscoveryRequestResolver;
import org.junit.platform.engine.support.discovery.SelectorResolver;

public abstract class AbstractClassBasedTestEngine
implements TestEngine {
    public TestDescriptor discover(EngineDiscoveryRequest engineDiscoveryRequest, UniqueId uniqueId) {
        EngineDescriptor engineDescriptor = new EngineDescriptor(uniqueId, this.createEngineDisplayName());
        EngineDiscoveryRequestResolver engineDiscoveryRequestResolver = EngineDiscoveryRequestResolver.builder().addClassContainerSelectorResolver(this::isTestClass).addSelectorResolver(initializationContext -> new Resolver(initializationContext.getClassNameFilter())).addTestDescriptorVisitor(initializationContext -> TestDescriptor::prune).build();
        engineDiscoveryRequestResolver.resolve(engineDiscoveryRequest, (TestDescriptor)engineDescriptor);
        return engineDescriptor;
    }

    public abstract boolean isTestClass(Class<?> var1);

    public abstract boolean isTestMethod(Method var1);

    public String createEngineDisplayName() {
        return this.getClass().getSimpleName();
    }

    public String createTestClassDisplayName(Class<?> clazz) {
        return clazz.getSimpleName();
    }

    public String createTestMethodDisplayName(Method method) {
        return method.getName() + "(" + Arrays.asList(method.getParameterTypes()) + ")";
    }

    public Object[] createTestArguments(Method method) {
        if (method.getParameterCount() == 0) {
            return new Object[0];
        }
        Class<?> clazz = method.getParameterTypes()[0];
        if (method.getParameterCount() == 1 && clazz.isArray()) {
            return new Object[]{Array.newInstance(clazz.getComponentType(), 0)};
        }
        throw new RuntimeException("Overriding createTestArguments(Method) might help");
    }

    public Stream<UnaryOperator<TestDescriptor>> createTestMethods(Method method) {
        return Stream.of(testDescriptor -> {
            UniqueId uniqueId = testDescriptor.getUniqueId().append("method", method.getName());
            String string = this.createTestMethodDisplayName(method);
            Object[] objectArray = this.createTestArguments(method);
            return new TestMethod(uniqueId, string, method, objectArray);
        });
    }

    public Object createTestInstance(Class<?> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException("Overriding createTestInstance(Class) might help", reflectiveOperationException);
        }
    }

    public void execute(ExecutionRequest executionRequest) {
        TestDescriptor testDescriptor = executionRequest.getRootTestDescriptor();
        EngineExecutionListener engineExecutionListener = executionRequest.getEngineExecutionListener();
        engineExecutionListener.executionStarted(testDescriptor);
        for (TestDescriptor testDescriptor2 : testDescriptor.getChildren()) {
            engineExecutionListener.executionStarted(testDescriptor2);
            if (testDescriptor2 instanceof TestClass) {
                this.execute(engineExecutionListener, (TestClass)testDescriptor2);
            }
            engineExecutionListener.executionFinished(testDescriptor2, TestExecutionResult.successful());
        }
        engineExecutionListener.executionFinished(testDescriptor, TestExecutionResult.successful());
    }

    public void execute(EngineExecutionListener engineExecutionListener, TestClass testClass) {
        Object object = this.createTestInstance(testClass.getTestClass());
        for (TestDescriptor testDescriptor : testClass.getChildren()) {
            engineExecutionListener.executionStarted(testDescriptor);
            TestExecutionResult testExecutionResult = this.execute(object, (TestMethod)testDescriptor);
            engineExecutionListener.executionFinished(testDescriptor, testExecutionResult);
        }
    }

    public TestExecutionResult execute(Object object, TestMethod testMethod) {
        try {
            Method method = testMethod.getTestMethod();
            Object[] objectArray = testMethod.getArguments();
            method.invoke(object, objectArray);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            Throwable throwable = reflectiveOperationException.getCause();
            if (throwable != null) {
                return TestExecutionResult.failed((Throwable)throwable);
            }
            return TestExecutionResult.failed((Throwable)reflectiveOperationException);
        }
        return TestExecutionResult.successful();
    }

    private static class TestClass
    extends AbstractTestDescriptor {
        private final Class<?> testClass;

        private TestClass(UniqueId uniqueId, String string, Class<?> clazz) {
            super(uniqueId, string, (TestSource)ClassSource.from(clazz));
            this.testClass = clazz;
        }

        Class<?> getTestClass() {
            return this.testClass;
        }

        public TestDescriptor.Type getType() {
            return TestDescriptor.Type.CONTAINER;
        }
    }

    protected static class TestMethod
    extends AbstractTestDescriptor {
        private final Method testMethod;
        private final Object[] arguments;

        protected TestMethod(UniqueId uniqueId, String string, Method method, Object[] objectArray) {
            super(uniqueId, string, (TestSource)MethodSource.from((Method)method));
            this.testMethod = method;
            this.arguments = objectArray;
        }

        Object[] getArguments() {
            return this.arguments;
        }

        Method getTestMethod() {
            return this.testMethod;
        }

        public TestDescriptor.Type getType() {
            return TestDescriptor.Type.TEST;
        }
    }

    private class Resolver
    implements SelectorResolver {
        private final Predicate<String> classNameFilter;

        Resolver(Predicate<String> predicate) {
            this.classNameFilter = predicate;
        }

        public SelectorResolver.Resolution resolve(ClassSelector classSelector, SelectorResolver.Context context) {
            if (!this.classNameFilter.test(classSelector.getClassName()) || !AbstractClassBasedTestEngine.this.isTestClass(classSelector.getJavaClass())) {
                return SelectorResolver.Resolution.unresolved();
            }
            Class clazz = classSelector.getJavaClass();
            TestDescriptor testDescriptor2 = (TestDescriptor)context.addToParent(testDescriptor -> Optional.of(this.createTestClassDescriptor((TestDescriptor)testDescriptor, clazz))).orElseThrow(Error::new);
            return SelectorResolver.Resolution.match((SelectorResolver.Match)SelectorResolver.Match.exact((TestDescriptor)testDescriptor2, () -> this.createMethodSelectors(clazz)));
        }

        private TestDescriptor createTestClassDescriptor(TestDescriptor testDescriptor, Class<?> clazz) {
            UniqueId uniqueId = testDescriptor.getUniqueId().append("class", clazz.getName());
            String string = AbstractClassBasedTestEngine.this.createTestClassDisplayName(clazz);
            return new TestClass(uniqueId, string, clazz);
        }

        private Set<MethodSelector> createMethodSelectors(Class<?> clazz) {
            List list = ReflectionSupport.findMethods(clazz, AbstractClassBasedTestEngine.this::isTestMethod, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
            return list.stream().map(method -> DiscoverySelectors.selectMethod((Class)clazz, (Method)method)).collect(Collectors.toSet());
        }

        public SelectorResolver.Resolution resolve(MethodSelector methodSelector, SelectorResolver.Context context) {
            Method method = methodSelector.getJavaMethod();
            if (!AbstractClassBasedTestEngine.this.isTestMethod(method)) {
                return SelectorResolver.Resolution.unresolved();
            }
            Set set = AbstractClassBasedTestEngine.this.createTestMethods(method).map(unaryOperator -> (TestDescriptor)context.addToParent(() -> DiscoverySelectors.selectClass((Class)methodSelector.getJavaClass()), testDescriptor -> Optional.of((TestDescriptor)unaryOperator.apply(testDescriptor))).orElseThrow(Error::new)).map(SelectorResolver.Match::exact).collect(Collectors.toSet());
            return SelectorResolver.Resolution.matches(set);
        }

        public SelectorResolver.Resolution resolve(UniqueIdSelector uniqueIdSelector, SelectorResolver.Context context) {
            UniqueId.Segment segment = uniqueIdSelector.getUniqueId().getLastSegment();
            if (segment.getType().equals("class")) {
                return SelectorResolver.Resolution.selectors(Collections.singleton(DiscoverySelectors.selectClass((String)segment.getValue())));
            }
            if (segment.getType().equals("method")) {
                UniqueId uniqueId = uniqueIdSelector.getUniqueId().removeLastSegment();
                String string = uniqueId.getLastSegment().getValue();
                return SelectorResolver.Resolution.selectors(Collections.singleton(DiscoverySelectors.selectMethod((String)string, (String)segment.getValue())));
            }
            return SelectorResolver.Resolution.unresolved();
        }
    }
}

